package com.ximai.mes.md.service;

import com.ximai.mes.md.domain.MdWorkunitWorker;

import java.util.List;

/**
 * 岗位资源Service接口
 *
 * @author generator
 * @date 2024-07-17
 */
public interface IMdWorkunitWorkerService {
    /**
     * 查询岗位资源
     *
     * @param id 岗位资源主键
     * @return 岗位资源
     */
    MdWorkunitWorker selectMdWorkunitWorkerById(Long id);

    /**
     * 查询岗位资源列表
     *
     * @param mdWorkunitWorker 岗位资源
     * @return 岗位资源集合
     */
    List<MdWorkunitWorker> selectMdWorkunitWorkerList(MdWorkunitWorker mdWorkunitWorker);

    /**
     * 新增岗位资源
     *
     * @param mdWorkunitWorker 岗位资源
     * @return 结果
     */
    int insertMdWorkunitWorker(MdWorkunitWorker mdWorkunitWorker);

    /**
     * 修改岗位资源
     *
     * @param mdWorkunitWorker 岗位资源
     * @return 结果
     */
    int updateMdWorkunitWorker(MdWorkunitWorker mdWorkunitWorker);

    /**
     * 批量删除岗位资源
     *
     * @param ids 需要删除的岗位资源主键集合
     * @return 结果
     */
    int deleteMdWorkunitWorkerByIds(Long[] ids);

    /**
     * 删除岗位资源信息
     *
     * @param id 岗位资源主键
     * @return 结果
     */
    int deleteMdWorkunitWorkerById(Long id);

    int insertObj(MdWorkunitWorker mdWorkunitWorker);

    int updateObj(MdWorkunitWorker mdWorkunitWorker);

    MdWorkunitWorker getMdWorkunitWorkerByUserName(MdWorkunitWorker mdWorkunitWorker);
}
