package com.ximai.mes.md.mapper;

import java.util.List;
import com.ximai.mes.md.domain.MdWorkshop;
import org.apache.ibatis.annotations.Delete;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;

/**
 * 车间Mapper接口
 *
 * @date 2022-05-07
 */
public interface MdWorkshopMapper
{
    /**
     * 查询车间
     *
     * @param workshopId 车间主键
     * @return 车间
     */
    public MdWorkshop selectMdWorkshopByWorkshopId(Long workshopId);

    @Select("select *from md_workshop where workshop_code=#{workshopCode}")
    public List<MdWorkshop> selectMdWorkshopByWorkshopCode(@Param("workshopCode") String workshopCode);


    @Select("select *from md_workshop where workshop_code=#{workshopCode}")
    public MdWorkshop selectMdWorkshopByWorkshopCodes(@Param("workshopCode") String workshopCode);

    /**
     * 查询车间列表
     *
     * @param mdWorkshop 车间
     * @return 车间集合
     */
    public List<MdWorkshop> selectMdWorkshopList(MdWorkshop mdWorkshop);

    /**
     * 检查车间编码是否唯一
     * @param mdWorkshop
     * @return
     */
    public MdWorkshop checkWorkshopCodeUnique(MdWorkshop mdWorkshop);

    /**
     * 检查车间名称是否唯一
     * @param mdWorkshop
     * @return
     */
    public MdWorkshop checkWorkshopNameUnique(MdWorkshop mdWorkshop);

    /**
     * 新增车间
     *
     * @param mdWorkshop 车间
     * @return 结果
     */
    public int insertMdWorkshop(MdWorkshop mdWorkshop);

    /**
     * 修改车间
     *
     * @param mdWorkshop 车间
     * @return 结果
     */
    public int updateMdWorkshop(MdWorkshop mdWorkshop);

    /**
     * 删除车间
     *
     * @param workshopId 车间主键
     * @return 结果
     */
    public int deleteMdWorkshopByWorkshopId(Long workshopId);

    /**
     * 批量删除车间
     *
     * @param workshopIds 需要删除的数据主键集合
     * @return 结果
     */
    public int deleteMdWorkshopByWorkshopIds(Long[] workshopIds);

    /**
     * 根据ep传的车间编码删除数据
     * @param workshopCode
     * @return
     */
    @Delete("delete from md_workshop where workshop_code=#{workshopCode}")
    public int  deleteMdWorkshopByWorkshopCode(@Param("workshopCode") String workshopCode);
}
