package com.ximai.mes.md.mapper;

import java.util.List;
import com.ximai.mes.md.domain.MdSalesReason;

/**
 * 销售订单原因Mapper接口
 *
 * @author yinjinlu
 * @date 2024-01-22
 */
public interface MdSalesReasonMapper
{
    /**
     * 查询销售订单原因
     *
     * @param id 销售订单原因主键
     * @return 销售订单原因
     */
    public MdSalesReason selectMdSalesReasonById(String id);

    /**
     * 查询销售订单原因列表
     *
     * @param mdSalesReason 销售订单原因
     * @return 销售订单原因集合
     */
    public List<MdSalesReason> selectMdSalesReasonList(MdSalesReason mdSalesReason);

    /**
     * 新增销售订单原因
     *
     * @param mdSalesReason 销售订单原因
     * @return 结果
     */
    public int insertMdSalesReason(MdSalesReason mdSalesReason);

    /**
     * 修改销售订单原因
     *
     * @param mdSalesReason 销售订单原因
     * @return 结果
     */
    public int updateMdSalesReason(MdSalesReason mdSalesReason);

    /**
     * 删除销售订单原因
     *
     * @param id 销售订单原因主键
     * @return 结果
     */
    public int deleteMdSalesReasonById(String id);

    /**
     * 批量删除销售订单原因
     *
     * @param ids 需要删除的数据主键集合
     * @return 结果
     */
    public int deleteMdSalesReasonByIds(String[] ids);
}
