package com.ximai.mes.md.mapper;

import java.util.List;
import com.ximai.mes.md.domain.MdBrandContact;

/**
 * 品牌联系人Mapper接口
 *
 * @author yinjinlu
 * @date 2024-01-16
 */
public interface MdBrandContactMapper{
    /**
     * 查询品牌联系人
     *
     * @param brandContactId 品牌联系人主键
     * @return 品牌联系人
     */
    MdBrandContact selectMdBrandContactByBrandContactId(Long brandContactId);

    /**
     * 查询品牌联系人列表
     *
     * @param mdBrandContact 品牌联系人
     * @return 品牌联系人集合
     */
    List<MdBrandContact> selectMdBrandContactList(MdBrandContact mdBrandContact);

    /**
     * 新增品牌联系人
     *
     * @param mdBrandContact 品牌联系人
     * @return 结果
     */
    int insertMdBrandContact(MdBrandContact mdBrandContact);

    /**
     * 修改品牌联系人
     *
     * @param mdBrandContact 品牌联系人
     * @return 结果
     */
    int updateMdBrandContact(MdBrandContact mdBrandContact);

    /**
     * 删除品牌联系人
     *
     * @param brandContactId 品牌联系人主键
     * @return 结果
     */
    int deleteMdBrandContactByBrandContactId(Long brandContactId);

    /**
     * 批量删除品牌联系人
     *
     * @param brandContactIds 需要删除的数据主键集合
     * @return 结果
     */
    int deleteMdBrandContactByBrandContactIds(Long[] brandContactIds);
}
