package com.ximai.mes.md.controller;

import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.ximai.common.annotation.Log;
import com.ximai.common.core.controller.BaseController;
import com.ximai.common.core.domain.AjaxResult;
import com.ximai.common.enums.BusinessType;
import com.ximai.mes.md.domain.MdSalesCurrency;
import com.ximai.mes.md.service.IMdSalesCurrencyService;
import com.ximai.common.core.page.TableDataInfo;

/**
 * 订单 交易币别Controller
 *
 * @author yinjinlu
 * @date 2024-01-22
 */
@RestController
@RequestMapping("/md/currency")
public class MdSalesCurrencyController extends BaseController
{
    @Autowired
    private IMdSalesCurrencyService mdSalesCurrencyService;

    /**
     * 查询订单 交易币别列表
     */
    @PreAuthorize("@ss.hasPermi('md:currency:list')")
    @GetMapping("/list")
    public TableDataInfo list(MdSalesCurrency mdSalesCurrency)
    {
        startPage();
        List<MdSalesCurrency> list = mdSalesCurrencyService.selectMdSalesCurrencyList(mdSalesCurrency);
        return getDataTable(list);
    }


    /**
     * 获取订单 交易币别详细信息
     */
    @PreAuthorize("@ss.hasPermi('md:currency:query')")
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") String id)
    {
        return AjaxResult.success(mdSalesCurrencyService.selectMdSalesCurrencyById(id));
    }

    /**
     * 新增订单 交易币别
     */
    @PreAuthorize("@ss.hasPermi('md:currency:add')")
    @Log(title = "订单 交易币别", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody MdSalesCurrency mdSalesCurrency)
    {
        return toAjax(mdSalesCurrencyService.insertMdSalesCurrency(mdSalesCurrency));
    }

    /**
     * 修改订单 交易币别
     */
    @PreAuthorize("@ss.hasPermi('md:currency:edit')")
    @Log(title = "订单 交易币别", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody MdSalesCurrency mdSalesCurrency)
    {
        return toAjax(mdSalesCurrencyService.updateMdSalesCurrency(mdSalesCurrency));
    }

    /**
     * 删除订单 交易币别
     */
    @PreAuthorize("@ss.hasPermi('md:currency:remove')")
    @Log(title = "订单 交易币别", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable String[] ids)
    {
        return toAjax(mdSalesCurrencyService.deleteMdSalesCurrencyByIds(ids));
    }
}
