package com.ximai.mes.kanban.dto.equipment;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

@Data
public class EquipmentStatDto {

    /**
     * 当日该产线所有工作单元的报工工时（分钟）/当日该产线所有工作单元的排班日历（分钟）
     */
    @ApiModelProperty("利用率")
    BigDecimal equipAvailability;
    /**
     * 当前产线的所有工作单元当日报工总和
     */
    @ApiModelProperty("总产量")
    BigDecimal totalOutput=BigDecimal.ZERO;
    @ApiModelProperty("设备数")
    Integer equipNum=0;
    /**
     * 当前产线的所有工作单元当日报工合格率（合格数量/报工数量）
     */
    @ApiModelProperty("合格率")
    BigDecimal qualifiedRatio=BigDecimal.ZERO;
    /**
     * 当前产线的所有工作单元当日为设备故障的异常单（当天）
     */
    @ApiModelProperty("异常数")
    Integer abnormalNum=0;
    /**
     * 当前产线的所有工作单元为设备故障的异常单数（状态不等于关闭和完成）
     */
    @ApiModelProperty("待处理数")
    Integer unProcessNum=0;
    @ApiModelProperty("设备列表")
    Map<String, List<EquipmentInfo>> equipMap;
    @ApiModelProperty("异常信息列表")
    List<AbnormalInfo> abnormalInfoList;

    @Data
    public static class EquipmentInfo{
        @ApiModelProperty("产线名称")
        String lineName;
        @ApiModelProperty("设备名称")
        String equipmentNo;
        @ApiModelProperty("设备名称")
        String equipmentName;
        /**
         * 当日该工作单元的报工数量
         */
        @ApiModelProperty("日产出")
        BigDecimal output=BigDecimal.ZERO;
        /**
         * 当日该工作单元的报工工时（分钟）/当日该工作单元的排班日历（分钟）*100%
         */
        @ApiModelProperty("产出率")
        BigDecimal outputRatio=BigDecimal.ZERO;
        /**
         * 0：加工中、1：未加工，2：停工
         * 工作单元的派工任务有为已开始则显示为绿色，如果异常停工则显示为红色，其他状态显示为灰色
         */
        @ApiModelProperty("状态，0：加工中、1：未加工，2：停工")
        int state;
    }

    @Data
    public static class AbnormalInfo{
        @ApiModelProperty("设备名称")
        String equipmentNo;
        @ApiModelProperty("设备名称")
        String equipmentName;
        @ApiModelProperty("原因")
        String cause;
        @ApiModelProperty("状态,NOT：待处理，SUBMIT：处理中")
        String state;
    }
}
