package com.ximai.mes.kanban.controller;

import com.ximai.common.core.domain.AjaxResult;
import com.ximai.mes.kanban.dto.material.ErpDataDto;
import com.ximai.mes.kanban.dto.material.MesDataDto;
import com.ximai.mes.kanban.dto.task.TaskPlanQuery;
import com.ximai.mes.kanban.dto.task.TaskPlanStatDto;
import com.ximai.mes.kanban.dto.task.TaskStatDto;
import com.ximai.mes.kanban.service.KanbanMaterialService;
import com.ximai.mes.kanban.service.KanbanTaskService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api("看板物料数据接口")
@RestController
@RequestMapping("/kanban/material")
public class KanbanMaterialController {

    @Autowired
    private KanbanMaterialService kanbanMaterialService;

    @ApiOperation("物料看板MES接口数据")
    @PostMapping("/mesData")
    public AjaxResult<MesDataDto> mesData() {
        MesDataDto rst = kanbanMaterialService.getMesData();
        return AjaxResult.success(rst);
    }

    @ApiOperation("物料看板ERP接口数据")
    @PostMapping("/erpData")
    public AjaxResult<ErpDataDto> erpData() {
        ErpDataDto rst = kanbanMaterialService.getErpData();
        return AjaxResult.success(rst);
    }

}
