package com.ximai.common.utils.data;

import com.ximai.common.exception.ServiceException;
import org.apache.commons.lang3.exception.ExceptionUtils;

import java.io.PrintWriter;
import java.io.StringWriter;

/**
 * 错误信息处理类。
 */
public class ExceptionUtil {
    /**
     * 获取exception的详细错误信息。
     */
    public static String getExceptionMessage(Throwable e) {
        StringWriter sw = new StringWriter();
        e.printStackTrace(new PrintWriter(sw, true));
        return sw.toString();
    }

    public static String getRootErrorMessage(Exception e) {
        Throwable root = ExceptionUtils.getRootCause(e);
        root = (root == null ? e : root);
        if (root == null) {
            return "";
        }
        String msg = root.getMessage();
        if (msg == null) {
            return "null";
        }
        return StringUtils.defaultString(msg);
    }

    public static void checkTrueThrowException(boolean conditon, String errorMsg) {
        if (conditon) {
            throw new ServiceException(errorMsg);
        }
    }


    public static void throwExcetion(String errorMsg) {
        throw new ServiceException(errorMsg);

    }
}
