package com.ximai.web.core.config;

import com.bstek.ureport.definition.datasource.BuildinDatasource;
import com.bstek.ureport.export.pdf.font.FontRegister;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import javax.annotation.Resource;
import javax.sql.DataSource;
import java.sql.Connection;
import java.sql.SQLException;

@EnableAutoConfiguration
@Configuration
public class UReportConfig implements BuildinDatasource {

    @Resource
    DataSource dataSource;

    /**
     * 返回数据源的名称
     * @return
     */
    @Override
    public String name() {
        return "内置数据源";
    }

    @Override
    public Connection getConnection() {
        try {
            return dataSource.getConnection();
        } catch (SQLException e) {
            e.printStackTrace();
            System.out.println("连接数据源失败！");
        }
        return null;
    }

    @Bean
    public FontRegister fontRegister() {
        return new FontRegister() {
            @Override
            public String getFontName() {
                return "ThaiSans";
            }

            @Override
            public String getFontPath() {
                return "classpath:reports/fonts/thaisansneue-regular-webfont.ttf";
            }
        };
    }

    @Bean
    public FontRegister fontRegister2() {
        return new FontRegister() {
            @Override
            public String getFontName() {
                return "Arial Narrow";
            }

            @Override
            public String getFontPath() {
                return "classpath:reports/fonts/ARIALN.TTF";
            }
        };
    }
}


