package com.ximai.system.dto;

import com.alibaba.excel.annotation.ExcelProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.ximai.common.annotation.Excel;
import com.ximai.common.annotation.Excel.ColumnType;
import com.ximai.common.core.domain.BaseEntity;
import com.ximai.common.utils.excel.converter.DateTimeConverter;
import com.ximai.common.utils.excel.converter.LocalDateTimeConverter;
import io.swagger.annotations.ApiModel;
import lombok.Data;

import java.util.Date;

/**
 * 系统访问记录表 sys_logininfor
 *
 */
@Data
@ApiModel("登录日志")
public class SysLogininforExcelExport
{
    private static final long serialVersionUID = 1L;

    /** ID */
    @ExcelProperty("序号")
    private Long infoId;

    /** 用户账号 */
    @ExcelProperty("用户账号")
    private String userName;

    /** 登录状态 0成功 1失败 */
    @ExcelProperty("登录状态")
    private String status;

    /** 登录IP地址 */
    @ExcelProperty("登录地址")
    private String ipaddr;

    /** 登录地点 */
    @ExcelProperty("登录地点")
    private String loginLocation;

    /** 浏览器类型 */
    @ExcelProperty("浏览器")
    private String browser;

    /** 操作系统 */
    @ExcelProperty("操作系统")
    private String os;

    /** 提示消息 */
    @ExcelProperty("提示消息")
    private String msg;

    /** 访问时间 */
    @ExcelProperty(value = "操作时间", converter = DateTimeConverter.class)
    private Date loginTime;
}
