package com.bs.mes.schedule;

import com.ximai.mes.pro.schedule.Calendar;
import com.ximai.mes.pro.schedule.CalendarManager;
import com.ximai.mes.pro.schedule.Equipment;
import com.ximai.mes.pro.schedule.Resource;
import org.junit.Assert;
import org.junit.Test;

import java.math.BigDecimal;
import java.time.Duration;
import java.util.List;

public class CalendarManagerTest {

    @Test public void addOccupiedCalendar(){
        //占用1个时间段的一段时间，2小时，120分钟
        Equipment resource = new Equipment(){{
            setIsParallel(false);
            setId(1l);
        }};
        CalendarManager calendarManager = this.buildCalendarManager(resource);
        calendarManager.addOccupiedCalendar(new Calendar.OccupiedCalendar(){{
            this.setStartedTime(Duration.ofMinutes(60*8));
            this.setEndedTime(Duration.ofMinutes(60*10));
            this.setQuantity(BigDecimal.valueOf(500));
            this.setResource(new Equipment(){{
                setIsParallel(false);
                setId(1l);
            }});
        }});
        List<Calendar.LeisureCalendar> leisureCalendarList = calendarManager.getLeisureCalendar(resource);
        Assert.assertEquals(Duration.ofMinutes(60*10), leisureCalendarList.get(0).getStartedTime());

        //占用2个时间段
        calendarManager = this.buildCalendarManager(resource);
        calendarManager.addOccupiedCalendar(new Calendar.OccupiedCalendar(){{
            this.setStartedTime(Duration.ofMinutes(60*6));
            this.setEndedTime(Duration.ofMinutes(60*14));
            this.setQuantity(BigDecimal.valueOf(500));
            this.setResource(new Equipment(){{
                setIsParallel(false);
                setId(1l);
            }});
        }});
        leisureCalendarList = calendarManager.getLeisureCalendar(resource);
        //第一个空闲时间被删除
        Assert.assertEquals(2, leisureCalendarList.size());
        //第二个空闲时间开始时间为6*14
        Assert.assertEquals(Duration.ofMinutes(60*14), leisureCalendarList.get(0).getStartedTime());

        //从中间占用时间段
        calendarManager = this.buildCalendarManager(resource);
        calendarManager.addOccupiedCalendar(new Calendar.OccupiedCalendar(){{
            this.setStartedTime(Duration.ofMinutes(60*9));
            this.setEndedTime(Duration.ofMinutes(60*10+25));
            this.setQuantity(BigDecimal.valueOf(500));
            this.setResource(new Equipment(){{
                setIsParallel(false);
                setId(1l);
            }});
        }});
        leisureCalendarList = calendarManager.getLeisureCalendar(resource);
        Assert.assertEquals(leisureCalendarList.size(), 4);
        Assert.assertEquals(Duration.ofMinutes(60*8), leisureCalendarList.get(0).getStartedTime());
        Assert.assertEquals(Duration.ofMinutes(60*9), leisureCalendarList.get(0).getEndedTime());
        Assert.assertEquals(leisureCalendarList.size(), 4);
        Assert.assertEquals(Duration.ofMinutes(60*10+25), leisureCalendarList.get(1).getStartedTime());
        Assert.assertEquals(Duration.ofMinutes(60*12), leisureCalendarList.get(1).getEndedTime());
    }

    //3个班次工作时间，8-12，1:30-17,22-24+2
    private CalendarManager buildCalendarManager(Resource resource){

        CalendarManager calendarManager = new CalendarManager();
        calendarManager.addWorkingCalendar(new Calendar.WorkingCalendar(){{
            this.setStartedTime(Duration.ofMinutes(60*8));
            this.setEndedTime(Duration.ofMinutes(60*12));
            this.setResource(resource);
        }});
        calendarManager.addWorkingCalendar(new Calendar.WorkingCalendar(){{
            this.setStartedTime(Duration.ofMinutes(60*13+30));
            this.setEndedTime(Duration.ofMinutes(60*17));
            this.setResource(resource);
        }});
        calendarManager.addWorkingCalendar(new Calendar.WorkingCalendar(){{
            this.setStartedTime(Duration.ofMinutes(60*22));
            this.setEndedTime(Duration.ofMinutes(60*26));
            this.setResource(resource);
        }});
        return calendarManager;
    }


}
