package com.ximai.mes.tm.service.impl;

import com.ximai.mes.tm.domain.TmToolRequestItem;
import com.ximai.mes.tm.mapper.TmToolRequestItemMapper;
import com.ximai.mes.tm.service.ITmToolRequestItemService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 刀模版物料申请单Service业务层处理
 *
 * @author generator
 * @date 2024-02-02
 */
@Service
public class TmToolRequestItemServiceImpl implements ITmToolRequestItemService {
    @Autowired
    private TmToolRequestItemMapper tmToolRequestItemMapper;

    /**
     * 查询刀模版物料申请单
     *
     * @param toolRequestItemId 刀模版物料申请单主键
     * @return 刀模版物料申请单
     */
    @Override
    public TmToolRequestItem selectTmToolRequestItemByToolRequestItemId(Long toolRequestItemId) {
        return tmToolRequestItemMapper.selectTmToolRequestItemByToolRequestItemId(toolRequestItemId);
    }

    /**
     * 查询刀模版物料申请单列表
     *
     * @param tmToolRequestItem 刀模版物料申请单
     * @return 刀模版物料申请单
     */
    @Override
    public List<TmToolRequestItem> selectTmToolRequestItemList(TmToolRequestItem tmToolRequestItem) {
        return tmToolRequestItemMapper.selectTmToolRequestItemList(tmToolRequestItem);
    }

    /**
     * 新增刀模版物料申请单
     *
     * @param tmToolRequestItem 刀模版物料申请单
     * @return 结果
     */
    @Override
    public int insertTmToolRequestItem(TmToolRequestItem tmToolRequestItem) {
        tmToolRequestItem.createAction();
        return tmToolRequestItemMapper.insertTmToolRequestItem(tmToolRequestItem);
    }
 
    /**
     * 修改刀模版物料申请单
     *
     * @param tmToolRequestItem 刀模版物料申请单
     * @return 结果
     */
    @Override
    public int updateTmToolRequestItem(TmToolRequestItem tmToolRequestItem) {
        tmToolRequestItem.updateAction();
        return tmToolRequestItemMapper.updateTmToolRequestItem(tmToolRequestItem);
    }

    /**
     * 批量删除刀模版物料申请单
     *
     * @param toolRequestItemIds 需要删除的刀模版物料申请单主键
     * @return 结果
     */
    @Override
    public int deleteTmToolRequestItemByToolRequestItemIds(Long[] toolRequestItemIds) {
        return tmToolRequestItemMapper.deleteTmToolRequestItemByToolRequestItemIds(toolRequestItemIds);
    }

    /**
     * 删除刀模版物料申请单信息
     *
     * @param toolRequestItemId 刀模版物料申请单主键
     * @return 结果
     */
    @Override
    public int deleteTmToolRequestItemByToolRequestItemId(Long toolRequestItemId) {
        return tmToolRequestItemMapper.deleteTmToolRequestItemByToolRequestItemId(toolRequestItemId);
    }
}
