package com.ximai.mes.tm.service;

import com.ximai.mes.tm.domain.TmToolRequestItem;

import java.util.List;

/**
 * 刀模版物料申请单Service接口
 *
 * @author generator
 * @date 2024-02-02
 */
public interface ITmToolRequestItemService {
    /**
     * 查询刀模版物料申请单
     *
     * @param toolRequestItemId 刀模版物料申请单主键
     * @return 刀模版物料申请单
     */
    TmToolRequestItem selectTmToolRequestItemByToolRequestItemId(Long toolRequestItemId);

    /**
     * 查询刀模版物料申请单列表
     *
     * @param tmToolRequestItem 刀模版物料申请单
     * @return 刀模版物料申请单集合
     */
    List<TmToolRequestItem> selectTmToolRequestItemList(TmToolRequestItem tmToolRequestItem);

    /**
     * 新增刀模版物料申请单
     *
     * @param tmToolRequestItem 刀模版物料申请单
     * @return 结果
     */
    int insertTmToolRequestItem(TmToolRequestItem tmToolRequestItem);

    /**
     * 修改刀模版物料申请单
     *
     * @param tmToolRequestItem 刀模版物料申请单
     * @return 结果
     */
    int updateTmToolRequestItem(TmToolRequestItem tmToolRequestItem);

    /**
     * 批量删除刀模版物料申请单
     *
     * @param toolRequestItemIds 需要删除的刀模版物料申请单主键集合
     * @return 结果
     */
    int deleteTmToolRequestItemByToolRequestItemIds(Long[] toolRequestItemIds);

    /**
     * 删除刀模版物料申请单信息
     *
     * @param toolRequestItemId 刀模版物料申请单主键
     * @return 结果
     */
    int deleteTmToolRequestItemByToolRequestItemId(Long toolRequestItemId);
}
