package com.ximai.mes.tm.controller;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ximai.common.annotation.Log;
import com.ximai.common.core.controller.BaseController;
import com.ximai.common.core.domain.AjaxResult;
import com.ximai.common.core.page.TableDataInfo;
import com.ximai.common.enums.BusinessType;
import com.ximai.mes.tm.domain.TmToolRequest;
import com.ximai.mes.tm.domain.TmToolRequestUse;
import com.ximai.mes.tm.mapper.TmToolRequestUseMapper;
import com.ximai.mes.tm.service.ITmToolRequestService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

/**
 * 刀模版申请单Controller
 *
 * @author generator
 * @date 2024-02-02
 */
@RestController
@RequestMapping("/tm/tmToolRequest")
public class TmToolRequestController extends BaseController {
    @Autowired
    private ITmToolRequestService tmToolRequestService;

    @Resource
    private TmToolRequestUseMapper tmToolRequestUseMapper;

    /**
     * 查询刀模版申请单列表
     */
    @PreAuthorize("@ss.hasPermi('tm:tmToolRequest:list')")
    @GetMapping("/list")
    public TableDataInfo list(TmToolRequest tmToolRequest) {
        startPage();
        List<TmToolRequest> list = tmToolRequestService.selectTmToolRequestList(tmToolRequest);
        return getDataTable(list);
    }

    /**
     * 查询刀模版申请单列表
     */
    @PreAuthorize("@ss.hasPermi('tm:tmToolRequest:list')")
    @GetMapping("/list/unused")
    public TableDataInfo unUselist(TmToolRequest tmToolRequest) {
        startPage();
        List<TmToolRequest> list = tmToolRequestService.selectTmToolRequestList(tmToolRequest);
        Set<Long> collect = list.stream().map(TmToolRequest::getToolRequestId).collect(Collectors.toSet());
        Set<Long> set = tmToolRequestUseMapper.selectListByQw(new QueryWrapper<TmToolRequestUse>().in("tool_request_id", collect)).stream().map(TmToolRequestUse::getToolRequestId).collect(Collectors.toSet());
        List<TmToolRequest> objects = new ArrayList<>();
        for (TmToolRequest toolRequest : list) {
            if (set.add(toolRequest.getToolRequestId())) {
                objects.add(toolRequest);
            }
        }
        return getDataTable(objects);
    }

    /**
     * 获取刀模版申请单详细信息
     */
//    @PreAuthorize("@ss.hasPermi('tm:tmToolRequest:query')")
    @GetMapping(value = "/{toolRequestId}")
    public AjaxResult getInfo(@PathVariable("toolRequestId") Long toolRequestId) {
        return AjaxResult.success(tmToolRequestService.selectTmToolRequestByToolRequestId(toolRequestId));
    }

    /**
     * 新增刀模版申请单
     */
    @PreAuthorize("@ss.hasPermi('tm:tmToolRequest:add')")
    @Log(title = "刀模版申请单", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody TmToolRequest tmToolRequest) {
        return toAjax(tmToolRequestService.insertTmToolRequestAndItem(tmToolRequest));
    }

    /**
     * 修改刀模版申请单
     */
    @PreAuthorize("@ss.hasPermi('tm:tmToolRequest:edit')")
    @Log(title = "刀模版申请单", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody TmToolRequest tmToolRequest) {
        return toAjax(tmToolRequestService.updateTmToolRequest(tmToolRequest));
    }

    /**
     * 删除刀模版申请单
     */
    @PreAuthorize("@ss.hasPermi('tm:tmToolRequest:remove')")
    @Log(title = "刀模版申请单", businessType = BusinessType.DELETE)
    @DeleteMapping("/{toolRequestIds}")
    public AjaxResult remove(@PathVariable Long[] toolRequestIds) {
        return toAjax(tmToolRequestService.deleteTmToolRequestByToolRequestIds(toolRequestIds));
    }
}
