package com.ximai.mes.restful;


import com.alibaba.fastjson.JSON;
import com.ximai.common.core.domain.AjaxResult;
import com.ximai.framework.security.BasicAuth;
import com.ximai.mes.pro.domain.vo.ProProcessVo;
import com.ximai.mes.pro.service.IProProcessService;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;


@RestController
@RequestMapping(value = "/api/v1/process")
public class ProcessRestController {
    @Autowired
    private IProProcessService proProcessService;

    @ApiOperation(value = "工序信息的创建")
    @BasicAuth
    @RequestMapping(value = "/processCreate", method = RequestMethod.POST)
    public AjaxResult processCreates(@RequestBody String proProcessJson) {
        try {
            ProProcessVo proProcessVo = JSON.parseObject(proProcessJson).toJavaObject(ProProcessVo.class);
            int i = proProcessService.processCreate(proProcessVo);
            switch (i) {
                case 1:
                    return AjaxResult.success("新增成功");
                case 2:
                    return AjaxResult.success("修改成功");
                case 3:
                    return AjaxResult.success("关闭成功");
                default:
                    break;
            }
        } catch (Exception e) {
            return AjaxResult.error(e.getMessage());
        }
        return AjaxResult.success();
    }
}
