package com.ximai.mes.qc.domain;

import java.util.Date;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;
import com.ximai.common.annotation.Excel;
import com.baomidou.mybatisplus.annotation.TableId;
import com.ximai.common.core.domain.BaseEntity;

/**
 * 车间异常单对象 qc_abnormal_report
 *
 * @author generator
 * @date 2024-02-20
 */
@Data
public class
QcAbnormalReport extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 车间异常单ID */
    @TableId
    private Long abnormalReportId;

    /** 编批单号 */
    @Excel(name = "编批单号")
    private String batchNumber;

    /** 编批单号 */
    @Excel(name = "车间异常单单号 来源于编码规则：ABNORMAL_NUMBER")
    private String abnormalNumber;


    /** 工序ID */
    @Excel(name = "工序ID")
    private Long processId;

    /** 工序编号 */
    @Excel(name = "工序编号")
    private String processCode;

    /** 工序名称 */
    @Excel(name = "工序名称")
    private String processName;

    /** 工作单元ID */
    @Excel(name = "工作单元ID")
    private Long workstationId;

    /** 工作单元编号 */
    @Excel(name = "工作单元编号")
    private String workstationCode;

    /** 工作单元名称 */
    @Excel(name = "工作单元名称")
    private String workstationName;

    /** 异常类型 */
    @Excel(name = "异常类型")
    private String abnormalType;

    /** 异常原因 */
    @Excel(name = "异常原因")
    private String abnormalReason;

    /** 异常时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "异常时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date abnormalTime;

    /** 单据状态 */
    @Excel(name = "单据状态")
    private String abnormalStatus;

    private Long taskId;

    /** 任务派工ID */
    @Excel(name = "任务派工ID")
    private Long taskWorkunitId;

    //开始时间
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "开始时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date beginPurchaseDate;

    //结束时间
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "结束时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date endPurchaseDate;


    /**
     * 单据开始处理时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date startTime;

    /**
     * 异常处理开始人
     */
    private String startBy;

    /**
     * 处理结束时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date endTime;

    /**
     * 处理结束人
     */
    private String endBy;

    /**
     * 处理该异常的耗时
     */
    private Long timeConsuming;

    private String remarks;
}
