package com.ximai.mes.pro.service.impl.prototypeRequest;

import java.util.List;

import com.ximai.mes.pro.domain.vo.ProPrototypeRequestProcessVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ximai.mes.pro.mapper.prototypeRequest.ProPrototypeRequestProcessMapper;
import com.ximai.mes.pro.domain.prototypeRequest.ProPrototypeRequestProcess;
import com.ximai.mes.pro.service.prototypeRequest.IProPrototypeRequestProcessService;

/**
 * 打样申请工序Service业务层处理
 *
 * @author zht
 * @date 2024-01-18
 */
@Service
public class ProPrototypeRequestProcessServiceImpl implements IProPrototypeRequestProcessService
{
    @Autowired
    private ProPrototypeRequestProcessMapper proPrototypeRequestProcessMapper;

    /**
     * 查询打样申请工序
     *
     * @param prototypeRequestProcessId 打样申请工序主键
     * @return 打样申请工序
     */
    @Override
    public ProPrototypeRequestProcess selectProPrototypeRequestProcessByPrototypeRequestProcessId(Long prototypeRequestProcessId)
    {
        return proPrototypeRequestProcessMapper.selectProPrototypeRequestProcessByPrototypeRequestProcessId(prototypeRequestProcessId);
    }

    /**
     * 查询打样申请工序列表
     *
     * @param proPrototypeRequestProcess 打样申请工序
     * @return 打样申请工序
     */
    @Override
    public List<ProPrototypeRequestProcessVo> selectProPrototypeRequestProcessList(ProPrototypeRequestProcess proPrototypeRequestProcess)
    {
        return proPrototypeRequestProcessMapper.selectProPrototypeRequestProcessList(proPrototypeRequestProcess);
    }

    /**
     * 新增打样申请工序
     *
     * @param proPrototypeRequestProcess 打样申请工序
     * @return 结果
     */
    @Override
    public int insertProPrototypeRequestProcess(ProPrototypeRequestProcess proPrototypeRequestProcess)
    {
        return proPrototypeRequestProcessMapper.insertProPrototypeRequestProcess(proPrototypeRequestProcess);
    }

    /**
     * 修改打样申请工序
     *
     * @param proPrototypeRequestProcess 打样申请工序
     * @return 结果
     */
    @Override
    public int updateProPrototypeRequestProcess(ProPrototypeRequestProcess proPrototypeRequestProcess)
    {
        return proPrototypeRequestProcessMapper.updateProPrototypeRequestProcess(proPrototypeRequestProcess);
    }

    /**
     * 批量删除打样申请工序
     *
     * @param prototypeRequestProcessIds 需要删除的打样申请工序主键
     * @return 结果
     */
    @Override
    public int deleteProPrototypeRequestProcessByPrototypeRequestProcessIds(Long[] prototypeRequestProcessIds)
    {
        return proPrototypeRequestProcessMapper.deleteProPrototypeRequestProcessByPrototypeRequestProcessIds(prototypeRequestProcessIds);
    }

    /**
     * 删除打样申请工序信息
     *
     * @param prototypeRequestProcessId 打样申请工序主键
     * @return 结果
     */
    @Override
    public int deleteProPrototypeRequestProcessByPrototypeRequestProcessId(Long prototypeRequestProcessId)
    {
        return proPrototypeRequestProcessMapper.deleteProPrototypeRequestProcessByPrototypeRequestProcessId(prototypeRequestProcessId);
    }
}
