package com.ximai.mes.pro.service.impl.productionSolution;

import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ximai.mes.pro.mapper.productionSolution.ProProductionSolutionProcessItemMapper;
import com.ximai.mes.pro.domain.productionSolution.ProProductionSolutionProcessItem;
import com.ximai.mes.pro.service.productionSolution.IProProductionSolutionProcessItemService;

/**
 * 生产版本工序物料Service业务层处理
 *
 * @author zht
 * @date 2024-01-23
 */
@Service
public class ProProductionSolutionProcessItemServiceImpl implements IProProductionSolutionProcessItemService
{
    @Autowired
    private ProProductionSolutionProcessItemMapper proProductionSolutionProcessItemMapper;

    /**
     * 查询生产版本工序物料
     *
     * @param productionSolutionProcessItemId 生产版本工序物料主键
     * @return 生产版本工序物料
     */
    @Override
    public ProProductionSolutionProcessItem selectProProductionSolutionProcessItemByProductionSolutionProcessItemId(Long productionSolutionProcessItemId)
    {
        return proProductionSolutionProcessItemMapper.selectProProductionSolutionProcessItemByProductionSolutionProcessItemId(productionSolutionProcessItemId);
    }

    /**
     * 查询生产版本工序物料列表
     *
     * @param proProductionSolutionProcessItem 生产版本工序物料
     * @return 生产版本工序物料
     */
    @Override
    public List<ProProductionSolutionProcessItem> selectProProductionSolutionProcessItemList(ProProductionSolutionProcessItem proProductionSolutionProcessItem)
    {
        return proProductionSolutionProcessItemMapper.selectProProductionSolutionProcessItemList(proProductionSolutionProcessItem);
    }

    /**
     * 新增生产版本工序物料
     *
     * @param proProductionSolutionProcessItem 生产版本工序物料
     * @return 结果
     */
    @Override
    public int insertProProductionSolutionProcessItem(ProProductionSolutionProcessItem proProductionSolutionProcessItem)
    {
        return proProductionSolutionProcessItemMapper.insertProProductionSolutionProcessItem(proProductionSolutionProcessItem);
    }

    /**
     * 修改生产版本工序物料
     *
     * @param proProductionSolutionProcessItem 生产版本工序物料
     * @return 结果
     */
    @Override
    public int updateProProductionSolutionProcessItem(ProProductionSolutionProcessItem proProductionSolutionProcessItem)
    {
        return proProductionSolutionProcessItemMapper.updateProProductionSolutionProcessItem(proProductionSolutionProcessItem);
    }

    /**
     * 批量删除生产版本工序物料
     *
     * @param productionSolutionProcessItemIds 需要删除的生产版本工序物料主键
     * @return 结果
     */
    @Override
    public int deleteProProductionSolutionProcessItemByProductionSolutionProcessItemIds(Long[] productionSolutionProcessItemIds)
    {
        return proProductionSolutionProcessItemMapper.deleteProProductionSolutionProcessItemByProductionSolutionProcessItemIds(productionSolutionProcessItemIds);
    }

    /**
     * 删除生产版本工序物料信息
     *
     * @param productionSolutionProcessItemId 生产版本工序物料主键
     * @return 结果
     */
    @Override
    public int deleteProProductionSolutionProcessItemByProductionSolutionProcessItemId(Long productionSolutionProcessItemId)
    {
        return proProductionSolutionProcessItemMapper.deleteProProductionSolutionProcessItemByProductionSolutionProcessItemId(productionSolutionProcessItemId);
    }
}
