package com.ximai.mes.pro.service.impl.productionMake;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import cn.hutool.core.bean.BeanUtil;
import com.ximai.mes.pro.domain.vo.ProProductionMakeProcessQcindexVo;
import com.ximai.mes.qc.domain.QcIndex;
import com.ximai.mes.qc.mapper.QcIndexMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ximai.mes.pro.mapper.productionMake.ProProductionMakeProcessQcindexMapper;
import com.ximai.mes.pro.domain.productionMake.ProProductionMakeProcessQcindex;
import com.ximai.mes.pro.service.productionMake.IProProductionMakeProcessQcindexService;

/**
 * 打样申请工序检验项Service业务层处理
 *
 * @author generator
 * @date 2024-01-27
 */
@Service
public class ProProductionMakeProcessQcindexServiceImpl implements IProProductionMakeProcessQcindexService
{
    @Autowired
    private ProProductionMakeProcessQcindexMapper proProductionMakeProcessQcindexMapper;
    @Autowired
    private QcIndexMapper qcIndexMapper;

    /**
     * 查询打样申请工序检验项
     *
     * @param productionMakeProcessQcindexId 打样申请工序检验项主键
     * @return 打样申请工序检验项
     */
    @Override
    public ProProductionMakeProcessQcindex selectProProductionMakeProcessQcindexByProductionMakeProcessQcindexId(Long productionMakeProcessQcindexId)
    {
        return proProductionMakeProcessQcindexMapper.selectProProductionMakeProcessQcindexByProductionMakeProcessQcindexId(productionMakeProcessQcindexId);
    }

    /**
     * 查询打样申请工序检验项列表
     *
     * @param proProductionMakeProcessQcindex 打样申请工序检验项
     * @return 打样申请工序检验项
     */
    @Override
    public List<ProProductionMakeProcessQcindex> selectProProductionMakeProcessQcindexList(ProProductionMakeProcessQcindex proProductionMakeProcessQcindex)
    {
        return proProductionMakeProcessQcindexMapper.selectProProductionMakeProcessQcindexList(proProductionMakeProcessQcindex);
    }

    @Override
    public List<ProProductionMakeProcessQcindexVo> selectProProductionMakeProcessQcindexVoList(ProProductionMakeProcessQcindex proProductionMakeProcessQcindex)
    {
        List<ProProductionMakeProcessQcindexVo> rst = new ArrayList<ProProductionMakeProcessQcindexVo>();
        ProProductionMakeProcessQcindex query = new ProProductionMakeProcessQcindex();
        query.setProductionMakeId(proProductionMakeProcessQcindex.getProductionMakeId());
        List<ProProductionMakeProcessQcindex> list = proProductionMakeProcessQcindexMapper.selectProProductionMakeProcessQcindexList(query);
        List<Long> ids = list.stream().map(s->s.getQcindexId()).collect(Collectors.toList());
        Map<Long, QcIndex> qcIndexMap = new HashMap<Long, QcIndex>();
        if(ids.size()>0){
            qcIndexMap.putAll(qcIndexMapper.selectBatchIds(ids).stream().collect(Collectors.toMap(s->s.getIndexId(), s->s)));
        }
        list.forEach(s->{
            ProProductionMakeProcessQcindexVo vo = new ProProductionMakeProcessQcindexVo();
            BeanUtil.copyProperties(s, vo);
            if(qcIndexMap.containsKey(s.getQcindexId())){
                BeanUtil.copyProperties(qcIndexMap.get(s.getQcindexId()), vo);
            }
            rst.add(vo);
        });
        return rst;
    }

    /**
     * 新增打样申请工序检验项
     *
     * @param proProductionMakeProcessQcindex 打样申请工序检验项
     * @return 结果
     */
    @Override
    public int insertProProductionMakeProcessQcindex(ProProductionMakeProcessQcindex proProductionMakeProcessQcindex)
    {
        return proProductionMakeProcessQcindexMapper.insertProProductionMakeProcessQcindex(proProductionMakeProcessQcindex);
    }

    /**
     * 修改打样申请工序检验项
     *
     * @param proProductionMakeProcessQcindex 打样申请工序检验项
     * @return 结果
     */
    @Override
    public int updateProProductionMakeProcessQcindex(ProProductionMakeProcessQcindex proProductionMakeProcessQcindex)
    {
        return proProductionMakeProcessQcindexMapper.updateProProductionMakeProcessQcindex(proProductionMakeProcessQcindex);
    }

    /**
     * 批量删除打样申请工序检验项
     *
     * @param productionMakeProcessQcindexIds 需要删除的打样申请工序检验项主键
     * @return 结果
     */
    @Override
    public int deleteProProductionMakeProcessQcindexByProductionMakeProcessQcindexIds(Long[] productionMakeProcessQcindexIds)
    {
        return proProductionMakeProcessQcindexMapper.deleteProProductionMakeProcessQcindexByProductionMakeProcessQcindexIds(productionMakeProcessQcindexIds);
    }

    /**
     * 删除打样申请工序检验项信息
     *
     * @param productionMakeProcessQcindexId 打样申请工序检验项主键
     * @return 结果
     */
    @Override
    public int deleteProProductionMakeProcessQcindexByProductionMakeProcessQcindexId(Long productionMakeProcessQcindexId)
    {
        return proProductionMakeProcessQcindexMapper.deleteProProductionMakeProcessQcindexByProductionMakeProcessQcindexId(productionMakeProcessQcindexId);
    }
}
