package com.ximai.mes.pro.mapper.productionMake;

import java.util.List;
import com.ximai.mes.pro.domain.productionMake.ProProductionMakeProcess;

/**
 * 量产制作工序Mapper接口
 *
 * @author chicheng.li
 * @date 2024-01-23
 */
public interface ProProductionMakeProcessMapper
{
    /**
     * 查询量产制作工序
     *
     * @param productionMakeProcessId 量产制作工序主键
     * @return 量产制作工序
     */
    public ProProductionMakeProcess selectProProductionMakeProcessByProductionMakeProcessId(Long productionMakeProcessId);

    /**
     * 查询量产制作工序列表
     *
     * @param proProductionMakeProcess 量产制作工序
     * @return 量产制作工序集合
     */
    public List<ProProductionMakeProcess> selectProProductionMakeProcessList(ProProductionMakeProcess proProductionMakeProcess);

    /**
     * 新增量产制作工序
     *
     * @param proProductionMakeProcess 量产制作工序
     * @return 结果
     */
    public int insertProProductionMakeProcess(ProProductionMakeProcess proProductionMakeProcess);

    /**
     * 修改量产制作工序
     *
     * @param proProductionMakeProcess 量产制作工序
     * @return 结果
     */
    public int updateProProductionMakeProcess(ProProductionMakeProcess proProductionMakeProcess);

    /**
     * 删除量产制作工序
     *
     * @param productionMakeProcessId 量产制作工序主键
     * @return 结果
     */
    public int deleteProProductionMakeProcessByProductionMakeProcessId(Long productionMakeProcessId);

    /**
     * 删除量产制作工序
     *
     * @param productionMakeId 量产制作工序主键
     * @return 结果
     */
    public int deleteProProductionMakeProcessByProductionMakeId(Long productionMakeId);

    /**
     * 批量删除量产制作工序
     *
     * @param productionMakeProcessIds 需要删除的数据主键集合
     * @return 结果
     */
    public int deleteProProductionMakeProcessByProductionMakeProcessIds(Long[] productionMakeProcessIds);
}
