package com.ximai.mes.pro.domain.vo.task;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.ximai.common.annotation.Excel;
import com.ximai.common.core.domain.BaseEntity;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.math.BigDecimal;
import java.util.Date;

/**
 * 派工任务转外协参数
 *
 * @author chiheng.li
 * @date 2024-09-10
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class TaskWorkunitToOutsourceParam {
    private static final long serialVersionUID = 1L;

    @ApiModelProperty("派工任务ID")
    private Long taskWorkunitId;

    @ApiModelProperty("转外协数量")
    private BigDecimal toOutsourceQuantity;

    @ApiModelProperty("计划结束时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date scheduleStartDate;

    @ApiModelProperty("计划结束时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date scheduleEndDate;

    @ApiModelProperty("供应商ID")
    private Long vendorId;

    @ApiModelProperty("供应商名称")
    private String vendorName;
}
