package com.ximai.mes.pro.controller.productionSolution;

import java.util.List;
import javax.servlet.http.HttpServletResponse;

import com.ximai.mes.pro.domain.productionSolution.ProProductionSolutionProcessTool;
import com.ximai.mes.pro.service.productionSolution.IProProductionSolutionProcessToolService;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.ximai.common.annotation.Log;
import com.ximai.common.core.controller.BaseController;
import com.ximai.common.core.domain.AjaxResult;
import com.ximai.common.enums.BusinessType;
import com.ximai.common.core.page.TableDataInfo;

/**
 * 生产版本工序工装夹具Controller
 *
 * @author generator
 * @date 2024-01-28
 */
@RestController
@RequestMapping("/md/tool")
public class ProProductionSolutionProcessToolController extends BaseController
{
    @Autowired
    private IProProductionSolutionProcessToolService proProductionSolutionProcessToolService;

    /**
     * 查询生产版本工序工装夹具列表
     */
    @PreAuthorize("@ss.hasPermi('md:tool:list')")
    @GetMapping("/list")
    public TableDataInfo list(ProProductionSolutionProcessTool proProductionSolutionProcessTool)
    {
        startPage();
        List<ProProductionSolutionProcessTool> list = proProductionSolutionProcessToolService.selectProProductionSolutionProcessToolList(proProductionSolutionProcessTool);
        return getDataTable(list);
    }


    /**
     * 获取生产版本工序工装夹具详细信息
     */
    @PreAuthorize("@ss.hasPermi('md:tool:query')")
    @GetMapping(value = "/{prototypeSolutionProcessToolId}")
    public AjaxResult getInfo(@PathVariable("prototypeSolutionProcessToolId") Long prototypeSolutionProcessToolId)
    {
        return AjaxResult.success(proProductionSolutionProcessToolService.selectProProductionSolutionProcessToolByPrototypeSolutionProcessToolId(prototypeSolutionProcessToolId));
    }

    /**
     * 新增生产版本工序工装夹具
     */
    @PreAuthorize("@ss.hasPermi('md:tool:add')")
    @Log(title = "生产版本工序工装夹具", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody ProProductionSolutionProcessTool proProductionSolutionProcessTool)
    {
        return toAjax(proProductionSolutionProcessToolService.insertProProductionSolutionProcessTool(proProductionSolutionProcessTool));
    }

    /**
     * 修改生产版本工序工装夹具
     */
    @PreAuthorize("@ss.hasPermi('md:tool:edit')")
    @Log(title = "生产版本工序工装夹具", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody ProProductionSolutionProcessTool proProductionSolutionProcessTool)
    {
        return toAjax(proProductionSolutionProcessToolService.updateProProductionSolutionProcessTool(proProductionSolutionProcessTool));
    }

    /**
     * 删除生产版本工序工装夹具
     */
    @PreAuthorize("@ss.hasPermi('md:tool:remove')")
    @Log(title = "生产版本工序工装夹具", businessType = BusinessType.DELETE)
	@DeleteMapping("/{prototypeSolutionProcessToolIds}")
    public AjaxResult remove(@PathVariable Long[] prototypeSolutionProcessToolIds)
    {
        return toAjax(proProductionSolutionProcessToolService.deleteProProductionSolutionProcessToolByPrototypeSolutionProcessToolIds(prototypeSolutionProcessToolIds));
    }
}
