package com.ximai.mes.pro.controller.productionMake;

import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.ximai.common.annotation.Log;
import com.ximai.common.core.controller.BaseController;
import com.ximai.common.core.domain.AjaxResult;
import com.ximai.common.enums.BusinessType;
import com.ximai.mes.pro.domain.productionMake.ProProductionMakeProcessItem;
import com.ximai.mes.pro.service.productionMake.IProProductionMakeProcessItemService;
import com.ximai.common.core.page.TableDataInfo;

/**
 * 量产制作工序物料Controller
 *
 * @author chicheng.li
 * @date 2024-01-23
 */
@RestController
@RequestMapping("/mes/pro/productionMakeProcessItem")
public class ProProductionMakeProcessItemController extends BaseController
{
    @Autowired
    private IProProductionMakeProcessItemService proProductionMakeProcessItemService;

    /**
     * 查询量产制作工序物料列表
     */
    @PreAuthorize("@ss.hasPermi('pro:productionMakeProcessItem:list')")
    @GetMapping("/list")
    public TableDataInfo list(ProProductionMakeProcessItem proProductionMakeProcessItem)
    {
        startPage();
        List<ProProductionMakeProcessItem> list = proProductionMakeProcessItemService.selectProProductionMakeProcessItemList(proProductionMakeProcessItem);
        return getDataTable(list);
    }

    /**
     * 获取量产制作工序物料详细信息
     */
    @PreAuthorize("@ss.hasPermi('pro:productionMakeProcessItem:query')")
    @GetMapping(value = "/{productionMakeProcessItemId}")
    public AjaxResult getInfo(@PathVariable("productionMakeProcessItemId") Long productionMakeProcessItemId)
    {
        return AjaxResult.success(proProductionMakeProcessItemService.selectProProductionMakeProcessItemByProductionMakeProcessItemId(productionMakeProcessItemId));
    }

    /**
     * 新增量产制作工序物料
     */
    @PreAuthorize("@ss.hasPermi('pro:productionMakeProcessItem:add')")
    @Log(title = "量产制作工序物料", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody ProProductionMakeProcessItem proProductionMakeProcessItem)
    {
        return toAjax(proProductionMakeProcessItemService.insertProProductionMakeProcessItem(proProductionMakeProcessItem));
    }

    /**
     * 修改量产制作工序物料
     */
    @PreAuthorize("@ss.hasPermi('pro:productionMakeProcessItem:edit')")
    @Log(title = "量产制作工序物料", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody ProProductionMakeProcessItem proProductionMakeProcessItem)
    {
        return toAjax(proProductionMakeProcessItemService.updateProProductionMakeProcessItem(proProductionMakeProcessItem));
    }

    /**
     * 删除量产制作工序物料
     */
    @PreAuthorize("@ss.hasPermi('pro:productionMakeProcessItem:remove')")
    @Log(title = "量产制作工序物料", businessType = BusinessType.DELETE)
	@DeleteMapping("/{productionMakeProcessItemIds}")
    public AjaxResult remove(@PathVariable Long[] productionMakeProcessItemIds)
    {
        return toAjax(proProductionMakeProcessItemService.deleteProProductionMakeProcessItemByProductionMakeProcessItemIds(productionMakeProcessItemIds));
    }
}
