package com.ximai.common.core.page;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class PaginationHelper<T> {
    private final List<T> list; // 假设这是你的数据列表
    private int pageSize; // 每页的大小

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public PaginationHelper(List<T> list, int pageSize) {
        this.list = list;
        this.pageSize = pageSize;
    }

    public PaginationHelper(List<T> list) {
        this.list = list;
    }

    public List<T> getPage(int pageNumber) {
        if (pageNumber < 1) {
            throw new IllegalArgumentException("Page number cannot be less than 1");
        }

        int fromIndex = (pageNumber - 1) * pageSize;
        if (fromIndex >= list.size()) {
            return new ArrayList<>(); // 如果超出范围，返回空列表
        }

        int toIndex = Math.min(fromIndex + pageSize, list.size());
        return list.subList(fromIndex, toIndex);
    }

    public int getTotalPages() {
        return (int) Math.ceil((double) list.size() / pageSize);
    }


    public static void main(String[] args) {

// 使用示例
        List<Integer> dataList = Arrays.asList(1, 2, 3, 4, 5, 6, 7, 8, 9, 10);
        PaginationHelper<Integer> paginator = new PaginationHelper<>(dataList, 3);

        List<Integer> page1 = paginator.getPage(1); // 第1页
        System.out.println(page1);
        List<Integer> page2 = paginator.getPage(2); // 第2页
        System.out.println(page2);

// ...

        int totalPages = paginator.getTotalPages(); // 总页数
        System.out.println(totalPages);

    }
}