package com.ximai.mes.report.response;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.ximai.common.annotation.Excel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;

@Data
public class WorkOrderProgressListResponse {
    private Long workorderId;
    /**
     * 项目号，订单号，生产工单，工单类型，产品编码，产品名称，计划数量，完工数量，在制进度（百分比），需求实际
     */
    @ApiModelProperty("客户项目号")
    private String customerProjectNo;


    @ApiModelProperty("订单单号")
    private String orderCode;

    @ApiModelProperty( "工单编码")
    private String workorderCode;

    /**
     * 工单类型
     */
    @ApiModelProperty(    "工单类型")
    private String workorderType;
    /**
     * 产品编号
     */
    @ApiModelProperty(   "产品编号")
    private String productCode;
    /**
     * 产品名称
     */
    @ApiModelProperty(   "产品名称")
    private String productName;

    @ApiModelProperty("计划数量")
    private BigDecimal quantity;
    /**
     * 已生产数量
     */
    @ApiModelProperty("已生产数量")
    private BigDecimal quantityProduced;
    /**
     * 已生产数量
     */
    @ApiModelProperty("在制进度")
    private BigDecimal quantityMu;

    @ApiModelProperty("需求时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date requestDate;
}

