package com.ximai.mes.report.controller;

import com.ximai.common.annotation.Log;
import com.ximai.common.core.controller.BaseController;
import com.ximai.common.core.page.TableDataInfo;
import com.ximai.common.enums.BusinessType;
import com.ximai.mes.report.request.FeedbackRequest;
import com.ximai.mes.report.request.WorkOrderProgressRequest;
import com.ximai.mes.report.response.FeedbackResponse;
import com.ximai.mes.report.response.WorkOrderProgressFeedbackListResponse;
import com.ximai.mes.report.response.WorkOrderProgressListResponse;
import com.ximai.mes.report.response.WorkOrderProgressProcessListResponse;
import com.ximai.mes.report.service.WorkOrderProgressService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.*;

import java.util.List;

@Api("生产进度")
@RestController
@RequestMapping("/report/pro/workOrderProgress")
public class WorkOrderProgressController  extends BaseController {

    @Autowired
    WorkOrderProgressService workOrderProgressService;

    @ApiOperation("生产进度:明细界面")
    @PreAuthorize("@ss.hasPermi('mes:pro:feedback:get')")
    @Log(title = "生产进度:明细界面", businessType = BusinessType.QUERY)
    @GetMapping("/getList")
    public TableDataInfo<WorkOrderProgressListResponse> getList( WorkOrderProgressRequest workOrderProgressRequest) {
        startPage();
        List<WorkOrderProgressListResponse> workOrderProgressListResponses = workOrderProgressService.getList(workOrderProgressRequest);
        return getDataTable(workOrderProgressListResponses);
    }

    @ApiOperation("生产进度:工序明细")
    @PreAuthorize("@ss.hasPermi('mes:pro:feedback:get')")
    @Log(title = "生产进度:工序明细", businessType = BusinessType.QUERY)
    @GetMapping("/getProcessList")
    public TableDataInfo<WorkOrderProgressProcessListResponse> getProcessList(@RequestParam("workorderCode") String workorderCode) {
        List<WorkOrderProgressProcessListResponse> workOrderProgressListResponses = workOrderProgressService.getProcessList(workorderCode);
        return getDataTable(workOrderProgressListResponses);
    }


    @ApiOperation("生产进度:报工明细")
    @PreAuthorize("@ss.hasPermi('mes:pro:feedback:get')")
    @Log(title = "生产进度:报工明细", businessType = BusinessType.QUERY)
    @GetMapping("/getFeedbackList")
    public TableDataInfo<WorkOrderProgressFeedbackListResponse> getFeedbackList(Long taskWorkunitId, Long taskId,@RequestParam("workorderCode") String workorderCode) {
        if(taskWorkunitId != null && taskWorkunitId == 0)
            taskWorkunitId = null;
        List<WorkOrderProgressFeedbackListResponse> workOrderProgressFeedbackListResponses = workOrderProgressService.getFeedbackList(workorderCode,taskId,taskWorkunitId);
        return getDataTable(workOrderProgressFeedbackListResponses);
    }
}
