package com.ximai.mes.report.controller;

import com.ximai.common.annotation.Log;
import com.ximai.common.core.domain.AjaxResult;
import com.ximai.common.enums.BusinessType;
import com.ximai.mes.report.request.MonthlyProductionReportRequest;
import com.ximai.mes.report.request.MonthlyProductionReportRequest;
import com.ximai.mes.report.service.MonthlyProductionReportService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

@Api("月产能对比统计")
@RestController
@RequestMapping("/monthlyProductionReport")
public class MonthlyProductionReportController {

    @Autowired
    MonthlyProductionReportService monthlyProductionReportService;

    @ApiOperation("月产能对比统计:统计方式工序")
    @PreAuthorize("@ss.hasPermi('mes:pro:dailyProductionReport:get')")
    @Log(title = "月产能对比统计:统计方式工序", businessType = BusinessType.QUERY)
    @GetMapping("/getListByProcess")
    public AjaxResult<List> getListByProcess(MonthlyProductionReportRequest monthlyProductionReportRequest) {
        List data = monthlyProductionReportService.getListByProcess(monthlyProductionReportRequest);
        return AjaxResult.success(data);
    }



    @ApiOperation("月产能对比统计:统计方式车间")
    @PreAuthorize("@ss.hasPermi('mes:pro:dailyProductionReport:get')")
    @Log(title = "月产能对比统计:统计方式车间", businessType = BusinessType.QUERY)
    @GetMapping("/getListByWorkshop")
    public AjaxResult<List> getListByWorkshop(MonthlyProductionReportRequest monthlyProductionReportRequest) {
        List data = monthlyProductionReportService.getListByWorkshop(monthlyProductionReportRequest);
        return AjaxResult.success(data);
    }


    @ApiOperation("月产能对比统计:统计方式工作中心")
    @PreAuthorize("@ss.hasPermi('mes:pro:dailyProductionReport:get')")
    @Log(title = "月产能对比统计:统计方式工作中心", businessType = BusinessType.QUERY)
    @GetMapping("/getListByWorkstation")
    public AjaxResult<List> getListByWorkstation(MonthlyProductionReportRequest monthlyProductionReportRequest) {
        List data = monthlyProductionReportService.getListByWorkstation(monthlyProductionReportRequest);
        return AjaxResult.success(data);
    }
    @ApiOperation("月产能对比统计:统计方式工作单元")
    @PreAuthorize("@ss.hasPermi('mes:pro:dailyProductionReport:get')")
    @Log(title = "月产能对比统计:统计方式工作单元", businessType = BusinessType.QUERY)
    @GetMapping("/getListByWorkunit")
    public AjaxResult<List> getListByWorkunit(MonthlyProductionReportRequest monthlyProductionReportRequest) {
        List data = monthlyProductionReportService.getListByWorkunit(monthlyProductionReportRequest);
        return AjaxResult.success(data);
    }

    @ApiOperation("月产能对比统计:统计方式报工人员")
    @PreAuthorize("@ss.hasPermi('mes:pro:dailyProductionReport:get')")
    @Log(title = "月产能对比统计:统计方式报工人员", businessType = BusinessType.QUERY)
    @GetMapping("/getListByUser")
    public AjaxResult<List> getListByUser(MonthlyProductionReportRequest monthlyProductionReportRequest) {
        List data = monthlyProductionReportService.getListByUser(monthlyProductionReportRequest);
        return AjaxResult.success(data);
    }

}
