package com.ximai.mes.pro.schedule.strategy;

import cn.hutool.core.util.NumberUtil;
import com.ximai.mes.pro.schedule.Equipment;
import com.ximai.mes.pro.schedule.IOperationTimeCalculator;
import com.ximai.mes.pro.schedule.Task;
import com.ximai.mes.pro.schedule.TaskSchedulingContext;

import java.time.Duration;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 设备序列号评估
 * 相同工作中心的工序，工序1取设备1、工序2取设备2
 */
public class EvaluateEquipmentSerial implements EvaluateEquipment{

    @Override
    public double evaluate(TaskSchedulingContext context, IOperationTimeCalculator.OperationTimePlan operationTimePlan
            , List<TaskSchedulingContext.TaskSchedulingResultContext> scheduleResult) {
        //设备按序号排序
        List<Equipment> allEquipment = scheduleResult.stream().map(s->{
            if(s.getEquipment().getSerial()==null){//为空优先级靠后
                s.getEquipment().setSerial(99);
            }
            return s.getEquipment();
        }).sorted(Comparator.comparing(Equipment::getSerial)).collect(Collectors.toList());
        int index = 0;
        Task currTask = context.getTask();
        Equipment currEquip = context.getEquipment();
        for(Task task : context.getJob().getTasks()){
            if(task.getId().equals(currTask.getId())){
                break;
            }
            if(task.getWorkCenterId().equals(currTask.getWorkCenterId())){
                index++;
            }
        }
        if(index>=allEquipment.size()){
            index = index%allEquipment.size();
        }
        if(currEquip.getId().equals(allEquipment.get(index).getId())){
            return 10;
        }
        return 0;
    }

    @Override
    public int weight() {
        return 1;
    }

}
