package com.ximai.mes.pro.mapper.productionSolution;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ximai.mes.pro.domain.productionSolution.ProProductionSolutionProcess;
import com.ximai.mes.pro.domain.vo.ProProductionSolutionProcessVo;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;

import java.util.List;

/**
 * 生产版本工序Mapper接口
 *
 * @author zht
 * @date 2024-01-23
 */
public interface ProProductionSolutionProcessMapper {
    /**
     * 查询生产版本工序
     *
     * @param productionSolutionProcessId 生产版本工序主键
     * @return 生产版本工序
     */
    ProProductionSolutionProcess selectProProductionSolutionProcessByProductionSolutionProcessId(Long productionSolutionProcessId);

    /**
     * 查询生产版本工序列表
     *
     * @param proProductionSolutionProcess 生产版本工序
     * @return 生产版本工序集合
     */
    List<ProProductionSolutionProcessVo> selectProProductionSolutionProcessList(ProProductionSolutionProcess proProductionSolutionProcess);

    /**
     * 新增生产版本工序
     *
     * @param proProductionSolutionProcess 生产版本工序
     * @return 结果
     */
    int insertProProductionSolutionProcess(ProProductionSolutionProcess proProductionSolutionProcess);

    /**
     * 修改生产版本工序
     *
     * @param proProductionSolutionProcess 生产版本工序
     * @return 结果
     */
    int updateProProductionSolutionProcess(ProProductionSolutionProcess proProductionSolutionProcess);

    /**
     * 删除生产版本工序
     *
     * @param productionSolutionProcessId 生产版本工序主键
     * @return 结果
     */
    int deleteProProductionSolutionProcessByProductionSolutionProcessId(Long productionSolutionProcessId);

    /**
     * 批量删除生产版本工序
     *
     * @param productionSolutionProcessIds 需要删除的数据主键集合
     * @return 结果
     */
    int deleteProProductionSolutionProcessByProductionSolutionProcessIds(Long[] productionSolutionProcessIds);

    List<ProProductionSolutionProcessVo> selectProProductionSolutionProcessByProductionSolutionId(Long productionSolutionId);

    /**
     * 查询生产版本工序列表
     *
     * @param query 生产版本工序
     * @return 生产版本工序集合
     */
    @Select(value = "select * from pro_production_solution_process ${ew.customSqlSegment}")
    List<ProProductionSolutionProcess> selectProProductionSolutionProcessListByQw(@Param("ew") QueryWrapper<ProProductionSolutionProcess> query);

    @Select("select *\n" +
            "from pro_production_solution t1\n" +
            "         inner join (select group_counter, group_key, sap_item_code\n" +
            "                     from pro_workorder\n" +
            "                     where arrange_code in (select arrange_code\n" +
            "                                            from pro_task\n" +
            "                                            where task_id in\n" +
            "                                                  (select task_id from pro_task_workunit where task_workunit_id = #{taskWorkunitId})) \n" +
            "                     limit 1) t2 on t1.group_counter = t2.group_counter and t1.group_key = t2.group_key and\n" +
            "                                    t1.group_key = t2.group_key\n" +
            "         inner join pro_production_solution_process t3 on t1.production_solution_id = t3.production_solution_id\n" +
            "where t3.process_id = #{processId}")
    ProProductionSolutionProcessVo selectObjByTwIdAndPIdAndWoId(@Param("taskWorkunitId") Long taskWorkunitId, @Param("processId") Long processId);
}
