package com.ximai.mes.md.service;

import com.ximai.mes.md.domain.MdProductBom;

import java.util.List;

/**
 * 产品BOM关系Service接口
 *
 * @date 2022-05-09
 */
public interface IMdProductBomService {
    /**
     * 查询产品BOM关系
     *
     * @param bomId 产品BOM关系主键
     * @return 产品BOM关系
     */
    MdProductBom selectMdProductBomByBomId(Long bomId);

    /**
     * 查询产品BOM关系列表
     *
     * @param mdProductBom 产品BOM关系
     * @return 产品BOM关系集合
     */
    List<MdProductBom> selectMdProductBomList(MdProductBom mdProductBom);

    /**
     * 新增产品BOM关系
     *
     * @param mdProductBom 产品BOM关系
     * @return 结果
     */
    int insertMdProductBom(MdProductBom mdProductBom);

    /**
     * 修改产品BOM关系
     *
     * @param mdProductBom 产品BOM关系
     * @return 结果
     */
    int updateMdProductBom(MdProductBom mdProductBom);

    /**
     * 批量删除产品BOM关系
     *
     * @param bomIds 需要删除的产品BOM关系主键集合
     * @return 结果
     */
    int deleteMdProductBomByBomIds(Long[] bomIds);

    /**
     * 删除产品BOM关系信息
     *
     * @param bomId 产品BOM关系主键
     * @return 结果
     */
    int deleteMdProductBomByBomId(Long bomId);
}
