package com.ximai.mes.cal.service;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ximai.mes.cal.domain.CalPlanWorkunit;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 计划工作单元Service接口
 *
 * @author generator
 * @date 2024-03-14
 */
public interface ICalPlanWorkunitService {
    /**
     * 查询计划工作单元
     *
     * @param planWorkunitId 计划工作单元主键
     * @return 计划工作单元
     */
    CalPlanWorkunit selectCalPlanWorkunitByPlanWorkunitId(Long planWorkunitId);

    /**
     * 查询计划工作单元列表
     *
     * @param calPlanWorkunit 计划工作单元
     * @return 计划工作单元集合
     */
    List<CalPlanWorkunit> selectCalPlanWorkunitList(CalPlanWorkunit calPlanWorkunit);


    /**
     * 查询计划工作单元列表
     *
     * @param query 计划工作单元
     * @return 计划工作单元集合
     */
    List<CalPlanWorkunit> selectListByQw(@Param("ew") QueryWrapper<CalPlanWorkunit> query);

    /**
     * 查询计划工作单元列表（排产专用）
     *
     * @param query 计划工作单元
     * @return 计划工作单元集合
     */
    List<CalPlanWorkunit> selectListWithSchedule(@Param("ew") QueryWrapper<CalPlanWorkunit> query);

    /**
     * 新增计划工作单元
     *
     * @param calPlanWorkunit 计划工作单元
     * @return 结果
     */
    int insertCalPlanWorkunit(CalPlanWorkunit calPlanWorkunit);

    /**
     * 修改计划工作单元
     *
     * @param calPlanWorkunit 计划工作单元
     * @return 结果
     */
    int updateCalPlanWorkunit(CalPlanWorkunit calPlanWorkunit);

    int updateCalPlanWorkunitWorkStatus(CalPlanWorkunit calPlanWorkunit);

    /**
     * 批量删除计划工作单元
     *
     * @param planWorkunitIds 需要删除的计划工作单元主键集合
     * @return 结果
     */
    int deleteCalPlanWorkunitByPlanWorkunitIds(Long[] planWorkunitIds);

    /**
     * 删除计划工作单元信息
     *
     * @param planWorkunitId 计划工作单元主键
     * @return 结果
     */
    int deleteCalPlanWorkunitByPlanWorkunitId(Long planWorkunitId);

    int delete(QueryWrapper<CalPlanWorkunit> eq);

}
