package com.ximai.mes.cal.mapper;

import java.util.List;

import com.ximai.mes.cal.domain.CalHoliday;

/**
 * 节假日设置Mapper接口
 *
 * @date 2022-06-08
 */
public interface CalHolidayMapper {
    /**
     * 查询节假日设置
     *
     * @param holidayId 节假日设置主键
     * @return 节假日设置
     */
    CalHoliday selectCalHolidayByHolidayId(Long holidayId);

    /**
     * 查询节假日设置列表
     *
     * @param calHoliday 节假日设置
     * @return 节假日设置集合
     */
    List<CalHoliday> selectCalHolidayList(CalHoliday calHoliday);

    /**
     * 新增节假日设置
     *
     * @param calHoliday 节假日设置
     * @return 结果
     */
    int insertCalHoliday(CalHoliday calHoliday);

    /**
     * 修改节假日设置
     *
     * @param calHoliday 节假日设置
     * @return 结果
     */
    int updateCalHoliday(CalHoliday calHoliday);

    /**
     * 删除节假日设置
     *
     * @param holidayId 节假日设置主键
     * @return 结果
     */
    int deleteCalHolidayByHolidayId(Long holidayId);

    /**
     * 批量删除节假日设置
     *
     * @param holidayIds 需要删除的数据主键集合
     * @return 结果
     */
    int deleteCalHolidayByHolidayIds(Long[] holidayIds);
}
