package com.ximai;

import com.bstek.ureport.console.UReportServlet;
import com.ximai.mes.md.service.IMdItemService;
import com.ximai.mes.pro.service.proWorkOrder.IProWorkorderService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.CommandLineRunner;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.cloud.openfeign.EnableFeignClients;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ImportResource;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.web.context.request.RequestContextListener;
import springfox.documentation.oas.annotations.EnableOpenApi;

/**
 * 启动程序
 */
@EnableAsync
@ImportResource("classpath:ureport-console-context.xml")
@SpringBootApplication(exclude = {DataSourceAutoConfiguration.class})
@EnableFeignClients(basePackages = {"com.ximai"})
@EnableScheduling
@EnableOpenApi
public class RuoYiApplication implements CommandLineRunner {

    public static void main(String[] args) {
        SpringApplication springApplication = new SpringApplication(RuoYiApplication.class);
        springApplication.run(args);
    }

    @Override
    public void run(String... args) throws Exception {
    }

    @Bean
    public ServletRegistrationBean urportServlet() {
        ServletRegistrationBean bean = new ServletRegistrationBean(new UReportServlet());
        bean.addUrlMappings("/ureport/*");
        return bean;
    }

}
