package com.ximai.mes.report.service.impl;

import com.ximai.common.utils.data.ExceptionUtil;
import com.ximai.mes.report.mapper.MonthlyProductionReportMapper;
import com.ximai.mes.report.request.MonthlyProductionReportRequest;
import com.ximai.mes.report.request.MonthlyProductionReportRequest;
import com.ximai.mes.report.service.MonthlyProductionReportService;
import org.checkerframework.checker.units.qual.A;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.text.SimpleDateFormat;
import java.util.*;

@Service
public class MonthlyProductionReportServiceImp implements MonthlyProductionReportService {
    private List<String> dateList =new ArrayList<String>(
            Arrays.asList( "01", "02", "03", "04", "05", "06", "07", "08", "09", "10", "11", "12"));
    @Autowired
    DailyProductionReportServiceImp dailyProductionReportServiceImp;
    @Autowired
    MonthlyProductionReportMapper monthlyProductionReportMapper;
    @Override
    public List getListByProcess(MonthlyProductionReportRequest dailyProductionReportRequest) {
        ExceptionUtil.checkTrueThrowException(dailyProductionReportRequest.getDateYear() == null,
                "请传入年份");
        List<Map> processDataList = monthlyProductionReportMapper.getListByProcess(dailyProductionReportRequest);
        List<Map> returnList = dailyProductionReportServiceImp.groupList(processDataList,"工序名称","工序编码","工序",dateList);
        return returnList;
    }


    @Override
    public List getListByWorkshop(MonthlyProductionReportRequest dailyProductionReportRequest) {
        ExceptionUtil.checkTrueThrowException(dailyProductionReportRequest.getDateYear() == null,
                "请传入年份");
        List<Map> processDataList = monthlyProductionReportMapper.getListByWorkshop(dailyProductionReportRequest);
        List<Map> returnList = dailyProductionReportServiceImp.groupList(processDataList,"车间名称","车间编码","车间",dateList);
        return returnList;
    }

    @Override
    public List getListByWorkstation(MonthlyProductionReportRequest dailyProductionReportRequest) {
        ExceptionUtil.checkTrueThrowException(dailyProductionReportRequest.getDateYear() == null,
                "请传入年份");
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        List<Map> processDataList = monthlyProductionReportMapper.getListByWorkstation(dailyProductionReportRequest);
        List<Map> returnList = dailyProductionReportServiceImp.groupList(processDataList,"工作中心名称","工作中心编码","工作中心",dateList);
        return returnList;
    }

    @Override
    public List getListByWorkunit(MonthlyProductionReportRequest dailyProductionReportRequest) {
        ExceptionUtil.checkTrueThrowException(dailyProductionReportRequest.getDateYear() == null,
                "请传入年份");
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        List<Map> processDataList = monthlyProductionReportMapper.getListByWorkunit(dailyProductionReportRequest);
        List<Map> returnList = dailyProductionReportServiceImp.groupList(processDataList,"工作单元名称","工作单元编码","工作单元",dateList);
        return returnList;
    }

    @Override
    public List getListByUser(MonthlyProductionReportRequest dailyProductionReportRequest) {
        ExceptionUtil.checkTrueThrowException(dailyProductionReportRequest.getDateYear() == null,
                "请传入年份");
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        List<Map> processDataList = monthlyProductionReportMapper.getListByUser(dailyProductionReportRequest);
        List<Map> returnList = dailyProductionReportServiceImp.groupList(processDataList,"报工人员名称","报工人员编码","报工人员",dateList);
        return returnList;
    }
}
