package com.ximai.mes.report.controller;

import com.ximai.common.annotation.Log;
import com.ximai.common.core.domain.AjaxResult;
import com.ximai.common.enums.BusinessType;
import com.ximai.mes.report.request.DailyProductionReportRequest;
import com.ximai.mes.report.request.WeeklyProductionReportRequest;
import com.ximai.mes.report.service.DailyProductionReportService;
import com.ximai.mes.report.service.MonthlyProductionReportService;
import com.ximai.mes.report.service.WeeklyProductionReportService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletResponse;
import java.util.List;

@Api("周产能对比统计")
@RestController
@RequestMapping("/weeklyProductionReport")
public class WeeklyProductionReportController {
    @Autowired
    WeeklyProductionReportService weeklyProductionReportService;

    @Autowired
    DailyProductionReportService dailyProductionReportService;


    @ApiOperation("周产能对比统计:获取周表头")
    @PreAuthorize("@ss.hasPermi('mes:pro:dailyProductionReport:get')")
    @Log(title = "周产能对比统计:获取周表头", businessType = BusinessType.QUERY)
    @GetMapping("/getDatas")
    public AjaxResult<List> getDatas(WeeklyProductionReportRequest weeklyProductionReportRequest) {
        List data = weeklyProductionReportService.getDatas(weeklyProductionReportRequest);
        return AjaxResult.success(data);
    }




    @ApiOperation("周产能对比统计:统计方式工序")
    @PreAuthorize("@ss.hasPermi('mes:pro:dailyProductionReport:get')")
    @Log(title = "周产能对比统计:统计方式工序", businessType = BusinessType.QUERY)
    @GetMapping("/getListByProcess")
    public AjaxResult<List> getListByProcess(WeeklyProductionReportRequest weeklyProductionReportRequest) {
        List data = weeklyProductionReportService.getListByProcess(weeklyProductionReportRequest);
        return AjaxResult.success(data);
    }


    /**
     * 日产能对比统计:统计方式工作中心导出
     */
    @PreAuthorize("@ss.hasPermi('pro:materialReturn:export')")
    @Log(title = "周产能对比统计:统计方式工序导出", businessType = BusinessType.EXPORT)
    @PostMapping("/getListByProcess/export")
    @ApiOperation("周产能对比统计:统计方式工序导出")
    public void getListByProcessExport(HttpServletResponse response, WeeklyProductionReportRequest weeklyProductionReportRequest) {
        List data = weeklyProductionReportService.getListByProcess(weeklyProductionReportRequest);
        List date = weeklyProductionReportService.getDatas(weeklyProductionReportRequest);
        dailyProductionReportService.export(response,data,"周产能对比统计-统计方式工序导出","工序名称","工序编码","工序",  date);
    }



    @ApiOperation("周产能对比统计:统计方式车间")
    @PreAuthorize("@ss.hasPermi('mes:pro:dailyProductionReport:get')")
    @Log(title = "周产能对比统计:统计方式车间", businessType = BusinessType.QUERY)
    @GetMapping("/getListByWorkshop")
    public AjaxResult<List> getListByWorkshop(WeeklyProductionReportRequest weeklyProductionReportRequest) {
        List data = weeklyProductionReportService.getListByWorkshop(weeklyProductionReportRequest);
        return AjaxResult.success(data);
    }


    /**
     * 日产能对比统计:统计方式工作中心导出
     */
    @PreAuthorize("@ss.hasPermi('pro:materialReturn:export')")
    @Log(title = "周产能对比统计:统计方式车间导出", businessType = BusinessType.EXPORT)
    @PostMapping("/getListByWorkshop/export")
    @ApiOperation("周产能对比统计:统计方式车间导出")
    public void getListByWorkshopExport(HttpServletResponse response, WeeklyProductionReportRequest weeklyProductionReportRequest) {
        List data = weeklyProductionReportService.getListByWorkshop(weeklyProductionReportRequest);
        List date = weeklyProductionReportService.getDatas(weeklyProductionReportRequest);
        dailyProductionReportService.export(response,data,"周产能对比统计-统计方式车间导出","车间名称","车间编码","车间",  date);
    }



    @ApiOperation("周产能对比统计:统计方式工作中心")
    @PreAuthorize("@ss.hasPermi('mes:pro:dailyProductionReport:get')")
    @Log(title = "周产能对比统计:统计方式工作中心", businessType = BusinessType.QUERY)
    @GetMapping("/getListByWorkstation")
    public AjaxResult<List> getListByWorkstation(WeeklyProductionReportRequest weeklyProductionReportRequest) {
        List data = weeklyProductionReportService.getListByWorkstation(weeklyProductionReportRequest);
        return AjaxResult.success(data);
    }


    /**
     * 日产能对比统计:统计方式工作中心导出
     */
    @PreAuthorize("@ss.hasPermi('pro:materialReturn:export')")
    @Log(title = "周产能对比统计:统计方式工作中心导出", businessType = BusinessType.EXPORT)
    @PostMapping("/getListByWorkstation/export")
    @ApiOperation("周产能对比统计:统计方式工作中心导出")
    public void getListByWorkstationExport(HttpServletResponse response, WeeklyProductionReportRequest weeklyProductionReportRequest) {
        List data = weeklyProductionReportService.getListByWorkstation(weeklyProductionReportRequest);
        List date = weeklyProductionReportService.getDatas(weeklyProductionReportRequest);
        dailyProductionReportService.export(response,data,"周产能对比统计-统计方式工作中心导出","工作中心名称","工作中心编码","工作中心",  date);
    }


    @ApiOperation("周产能对比统计:统计方式工作单元")
    @PreAuthorize("@ss.hasPermi('mes:pro:dailyProductionReport:get')")
    @Log(title = "周产能对比统计:统计方式工作单元", businessType = BusinessType.QUERY)
    @GetMapping("/getListByWorkunit")
    public AjaxResult<List> getListByWorkunit(WeeklyProductionReportRequest weeklyProductionReportRequest) {
        List data = weeklyProductionReportService.getListByWorkunit(weeklyProductionReportRequest);
        return AjaxResult.success(data);
    }

    /**
     * 日产能对比统计:统计方式工作中心导出
     */
    @PreAuthorize("@ss.hasPermi('pro:materialReturn:export')")
    @Log(title = "周产能对比统计:统计方式工作单元导出", businessType = BusinessType.EXPORT)
    @PostMapping("/getListByWorkunit/export")
    @ApiOperation("周产能对比统计:统计方式工作单元导出")
    public void getListByWorkunitExport(HttpServletResponse response, WeeklyProductionReportRequest weeklyProductionReportRequest) {
        List data = weeklyProductionReportService.getListByWorkunit(weeklyProductionReportRequest);
        List date = weeklyProductionReportService.getDatas(weeklyProductionReportRequest);
        dailyProductionReportService.export(response,data,"周产能对比统计-统计方式工作单元导出","工作单元名称","工作单元编码","工作单元",  date);
    }






    @ApiOperation("周产能对比统计:统计方式报工人员")
    @PreAuthorize("@ss.hasPermi('mes:pro:dailyProductionReport:get')")
    @Log(title = "周产能对比统计:统计方式报工人员", businessType = BusinessType.QUERY)
    @GetMapping("/getListByUser")
    public AjaxResult<List> getListByUser(WeeklyProductionReportRequest weeklyProductionReportRequest) {
        List data = weeklyProductionReportService.getListByUser(weeklyProductionReportRequest);
        return AjaxResult.success(data);
    }



    /**
     * 日产能对比统计:统计方式工作中心导出
     */
    @PreAuthorize("@ss.hasPermi('pro:materialReturn:export')")
    @Log(title = "周产能对比统计:统计方式报工人员导出", businessType = BusinessType.EXPORT)
    @PostMapping("/getListByUser/export")
    @ApiOperation("周产能对比统计:统计方式报工人员导出")
    public void getListByUserExport(HttpServletResponse response, WeeklyProductionReportRequest weeklyProductionReportRequest) {
        List data = weeklyProductionReportService.getListByUser(weeklyProductionReportRequest);
        List date = weeklyProductionReportService.getDatas(weeklyProductionReportRequest);
        dailyProductionReportService.export(response,data,"周产能对比统计-统计方式报工人员导出","报工人员名称","报工人员编码","报工人员",  date);
    }

}
