package com.ximai.mes.report.controller;

import com.ximai.common.annotation.Log;
import com.ximai.common.core.controller.BaseController;
import com.ximai.common.core.domain.AjaxResult;
import com.ximai.common.core.page.TableDataInfo;
import com.ximai.common.enums.BusinessType;
import com.ximai.common.utils.poi.ExcelUtil;
import com.ximai.mes.report.request.FeedbackRequest;
import com.ximai.mes.report.response.FeedbackResponse;
import com.ximai.mes.report.service.FeedbackService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.checkerframework.checker.units.qual.A;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.util.List;

@Api("生产报工报表")
@RestController
@RequestMapping("/report/pro/feedback")
public class FeedbackController extends BaseController {

    @Autowired
    FeedbackService feedbackService;
    /**
     * 新增生产报工记录
     */
    @ApiOperation("生产报工记录:明细界面")
    @PreAuthorize("@ss.hasPermi('mes:pro:feedback:get')")
    @Log(title = "生产报工记录", businessType = BusinessType.QUERY)
    @GetMapping("/getList")
    public TableDataInfo<FeedbackResponse> getList(FeedbackRequest feedbackRequest) {
        startPage();
        List<FeedbackResponse> feedbackResponseList = feedbackService.getList(feedbackRequest);
        return getDataTable(feedbackResponseList);
    }


    /**
     * 明细界面导出
     */
    @PreAuthorize("@ss.hasPermi('pro:materialReturn:export')")
    @Log(title = "生产报工记录:明细界面导出", businessType = BusinessType.EXPORT)
    @PostMapping("/getList/export")
    @ApiOperation("生产报工记录:明细界面导出")
    public void export(HttpServletResponse response, FeedbackRequest feedbackRequest) {
        List<FeedbackResponse> feedbackResponseList = feedbackService.getList(feedbackRequest);
        ExcelUtil<FeedbackResponse> util = new ExcelUtil<>(FeedbackResponse.class);
        util.exportExcel(response, feedbackResponseList, "生产报工报表明细");
    }

    @ApiOperation("生产报工记录:统计方式工单")
    @PreAuthorize("@ss.hasPermi('mes:pro:feedback:get')")
    @Log(title = "生产报工记录:统计方式工单", businessType = BusinessType.QUERY)
    @GetMapping("/getListByWorkOrder")
    public TableDataInfo<FeedbackResponse> getListByWorkOrder(     FeedbackRequest feedbackRequest) {
        startPage();
        List<FeedbackResponse> feedbackResponseList = feedbackService.getListByWorkOrder(feedbackRequest);
        DecimalFormat df = new DecimalFormat("0.00%");
        for(FeedbackResponse feedbackResponse : feedbackResponseList){
            if(feedbackResponse.getQuantityFeedback() != null
                    && feedbackResponse.getQuantityFeedback().compareTo(BigDecimal.ZERO) != 0
                    && feedbackResponse.getQuantityUnqualify()!= null ){
                feedbackResponse.setQualificationRate(df.format((feedbackResponse.getQuantityQualify().divide(feedbackResponse.getQuantityQualify().add(feedbackResponse.getQuantityUnqualify()),2, RoundingMode.HALF_UP).doubleValue())));
            }else{
                feedbackResponse.setQualificationRate("0.00%");
            }
        }
        return getDataTable(feedbackResponseList);
    }



    /**
     * 明细界面导出
     */
    @PreAuthorize("@ss.hasPermi('pro:materialReturn:export')")
    @Log(title = "生产报工记录:统计方式工单界面导出", businessType = BusinessType.EXPORT)
    @PostMapping("/getListByWorkOrder/export")
    @ApiOperation("生产报工记录:统计方式工单界面导出")
    public void getListByWorkOrderExport(HttpServletResponse response, FeedbackRequest feedbackRequest) {
        List<FeedbackResponse> feedbackResponseList = feedbackService.getListByWorkOrder(feedbackRequest);
        DecimalFormat df = new DecimalFormat("0.00%");
        for(FeedbackResponse feedbackResponse : feedbackResponseList){
            if(feedbackResponse.getQuantityFeedback() != null
                    && feedbackResponse.getQuantityFeedback().compareTo(BigDecimal.ZERO) != 0
                    && feedbackResponse.getQuantityUnqualify()!= null ){
                feedbackResponse.setQualificationRate(df.format((feedbackResponse.getQuantityQualify().divide(feedbackResponse.getQuantityQualify().add(feedbackResponse.getQuantityUnqualify()),2, RoundingMode.HALF_UP).doubleValue())));
            }else{
                feedbackResponse.setQualificationRate("0.00%");
            }
        }
        ExcelUtil<FeedbackResponse> util = new ExcelUtil<>(FeedbackResponse.class);
        util.exportExcel(response, feedbackResponseList, "生产报工报表-统计方式工单");
    }




    @ApiOperation("生产报工记录:统计方式车间")
    @PreAuthorize("@ss.hasPermi('mes:pro:feedback:get')")
    @Log(title = "生产报工记录:统计方式车间", businessType = BusinessType.QUERY)
    @GetMapping("/getListByWorkshop")
    public TableDataInfo<FeedbackResponse> getListByWorkshop(     FeedbackRequest feedbackRequest) {
        startPage();
        List<FeedbackResponse> feedbackResponseList = feedbackService.getListByWorkshop(feedbackRequest);
        DecimalFormat df = new DecimalFormat("0.00%");
        for(FeedbackResponse feedbackResponse : feedbackResponseList){
            if(feedbackResponse.getQuantityFeedback() != null
                    && feedbackResponse.getQuantityFeedback().compareTo(BigDecimal.ZERO) != 0
                    && feedbackResponse.getQuantityUnqualify()!= null ){
                feedbackResponse.setQualificationRate(df.format((feedbackResponse.getQuantityQualify().divide(feedbackResponse.getQuantityQualify().add(feedbackResponse.getQuantityUnqualify()),2, RoundingMode.HALF_UP).doubleValue())));
            }else{
                feedbackResponse.setQualificationRate("0.00%");
            }
        }
        return getDataTable(feedbackResponseList);
    }

    /**
     * 统计方式车间界面导出
     */
    @PreAuthorize("@ss.hasPermi('pro:materialReturn:export')")
    @Log(title = "生产报工记录:统计方式车间界面导出", businessType = BusinessType.EXPORT)
    @PostMapping("/getListByWorkshop/export")
    @ApiOperation("生产报工记录:统计方式车间界面导出")
    public void getListByWorkshopExport(HttpServletResponse response, FeedbackRequest feedbackRequest) {
        List<FeedbackResponse> feedbackResponseList = feedbackService.getListByWorkshop(feedbackRequest);
        DecimalFormat df = new DecimalFormat("0.00%");
        for(FeedbackResponse feedbackResponse : feedbackResponseList){
            if(feedbackResponse.getQuantityFeedback() != null
                    && feedbackResponse.getQuantityFeedback().compareTo(BigDecimal.ZERO) != 0
                    && feedbackResponse.getQuantityUnqualify()!= null ){
                feedbackResponse.setQualificationRate(df.format((feedbackResponse.getQuantityQualify().divide(feedbackResponse.getQuantityQualify().add(feedbackResponse.getQuantityUnqualify()),2, RoundingMode.HALF_UP).doubleValue())));
            }else{
                feedbackResponse.setQualificationRate("0.00%");
            }
        }
        ExcelUtil<FeedbackResponse> util = new ExcelUtil<>(FeedbackResponse.class);
        util.exportExcel(response, feedbackResponseList, "生产报工报表-统计方式车间");
    }


    @ApiOperation("生产报工记录:统计方式工作中心")
    @PreAuthorize("@ss.hasPermi('mes:pro:feedback:get')")
    @Log(title = "生产报工记录:统计方式工作中心", businessType = BusinessType.QUERY)
    @GetMapping("/getListByWorkstation")
    public TableDataInfo<FeedbackResponse> getListByWorkstation(     FeedbackRequest feedbackRequest) {
        startPage();
        List<FeedbackResponse> feedbackResponseList = feedbackService.getListByWorkstation(feedbackRequest);
        DecimalFormat df = new DecimalFormat("0.00%");
        for(FeedbackResponse feedbackResponse : feedbackResponseList){
            if(feedbackResponse.getQuantityFeedback() != null
                    && feedbackResponse.getQuantityFeedback().compareTo(BigDecimal.ZERO) != 0
                    && feedbackResponse.getQuantityUnqualify()!= null ){
                feedbackResponse.setQualificationRate(df.format((feedbackResponse.getQuantityQualify().divide(feedbackResponse.getQuantityQualify().add(feedbackResponse.getQuantityUnqualify()),2, RoundingMode.HALF_UP).doubleValue())));
            }else{
                feedbackResponse.setQualificationRate("0.00%");
            }
        }
        return getDataTable(feedbackResponseList);
    }


    /**
     * 统计方式车间界面导出
     */
    @PreAuthorize("@ss.hasPermi('pro:materialReturn:export')")
    @Log(title = "生产报工记录:统计方式工作中心导出", businessType = BusinessType.EXPORT)
    @PostMapping("/getListByWorkstation/export")
    @ApiOperation("生产报工记录:统计方式工作中心导出")
    public void getListByWorkstationExport(HttpServletResponse response, FeedbackRequest feedbackRequest) {
        List<FeedbackResponse> feedbackResponseList = feedbackService.getListByWorkstation(feedbackRequest);
        DecimalFormat df = new DecimalFormat("0.00%");
        for(FeedbackResponse feedbackResponse : feedbackResponseList){
            if(feedbackResponse.getQuantityFeedback() != null
                    && feedbackResponse.getQuantityFeedback().compareTo(BigDecimal.ZERO) != 0
                    && feedbackResponse.getQuantityUnqualify()!= null ){
                feedbackResponse.setQualificationRate(df.format((feedbackResponse.getQuantityQualify().divide(feedbackResponse.getQuantityQualify().add(feedbackResponse.getQuantityUnqualify()),2, RoundingMode.HALF_UP).doubleValue())));
            }else{
                feedbackResponse.setQualificationRate("0.00%");
            }
        }
        ExcelUtil<FeedbackResponse> util = new ExcelUtil<>(FeedbackResponse.class);
        util.exportExcel(response, feedbackResponseList, "生产报工报表-统计方式工作中心");
    }

    @ApiOperation("生产报工记录:统计方式工作单元")
    @PreAuthorize("@ss.hasPermi('mes:pro:feedback:get')")
    @Log(title = "生产报工记录:统计方式工作单元", businessType = BusinessType.QUERY)
    @GetMapping("/getListByWorkunit")
    public TableDataInfo<FeedbackResponse> getListByWorkunit(     FeedbackRequest feedbackRequest) {
        startPage();
        List<FeedbackResponse> feedbackResponseList = feedbackService.getListByWorkunit(feedbackRequest);
        DecimalFormat df = new DecimalFormat("0.00%");
        for(FeedbackResponse feedbackResponse : feedbackResponseList){
            if(feedbackResponse.getQuantityFeedback() != null
                    && feedbackResponse.getQuantityFeedback().compareTo(BigDecimal.ZERO) != 0
                    && feedbackResponse.getQuantityUnqualify()!= null ){
                feedbackResponse.setQualificationRate(df.format((feedbackResponse.getQuantityQualify().divide(feedbackResponse.getQuantityQualify().add(feedbackResponse.getQuantityUnqualify()),2, RoundingMode.HALF_UP).doubleValue())));
            }else{
                feedbackResponse.setQualificationRate("0.00%");
            }
        }
        return getDataTable(feedbackResponseList);
    }


    /**
     * 统计方式车间界面导出
     */
    @PreAuthorize("@ss.hasPermi('pro:materialReturn:export')")
    @Log(title = "生产报工记录:统计统计方式工作单元导出", businessType = BusinessType.EXPORT)
    @PostMapping("/getListByWorkunit/export")
    @ApiOperation("生产报工记录:统计统计方式工作单元导出")
    public void getListByWorkunitExport(HttpServletResponse response, FeedbackRequest feedbackRequest) {
        List<FeedbackResponse> feedbackResponseList = feedbackService.getListByWorkunit(feedbackRequest);
        DecimalFormat df = new DecimalFormat("0.00%");
        for(FeedbackResponse feedbackResponse : feedbackResponseList){
            if(feedbackResponse.getQuantityFeedback() != null
                    && feedbackResponse.getQuantityFeedback().compareTo(BigDecimal.ZERO) != 0
                    && feedbackResponse.getQuantityUnqualify()!= null ){
                feedbackResponse.setQualificationRate(df.format((feedbackResponse.getQuantityQualify().divide(feedbackResponse.getQuantityQualify().add(feedbackResponse.getQuantityUnqualify()),2, RoundingMode.HALF_UP).doubleValue())));
            }else{
                feedbackResponse.setQualificationRate("0.00%");
            }
        }
        ExcelUtil<FeedbackResponse> util = new ExcelUtil<>(FeedbackResponse.class);
        util.exportExcel(response, feedbackResponseList, "生产报工报表-统计方式工作单元");
    }



    @ApiOperation("生产报工记录:统计方式工序")
    @PreAuthorize("@ss.hasPermi('mes:pro:feedback:get')")
    @Log(title = "生产报工记录:统计方式工序", businessType = BusinessType.QUERY)
    @GetMapping("/getListByProcess")
    public TableDataInfo<FeedbackResponse> getListByProcess(     FeedbackRequest feedbackRequest) {
        startPage();
        List<FeedbackResponse> feedbackResponseList = feedbackService.getListByProcess(feedbackRequest);
        DecimalFormat df = new DecimalFormat("0.00%");
        for(FeedbackResponse feedbackResponse : feedbackResponseList){
            if(feedbackResponse.getQuantityFeedback() != null
                    && feedbackResponse.getQuantityFeedback().compareTo(BigDecimal.ZERO) != 0
                    && feedbackResponse.getQuantityUnqualify()!= null ){
                feedbackResponse.setQualificationRate(df.format((feedbackResponse.getQuantityQualify().divide(feedbackResponse.getQuantityQualify().add(feedbackResponse.getQuantityUnqualify()),2, RoundingMode.HALF_UP).doubleValue())));
            }else{
                feedbackResponse.setQualificationRate("0.00%");
            }
        }
        return getDataTable(feedbackResponseList);
    }

    /**
     * 统计方式车间界面导出
     */
    @PreAuthorize("@ss.hasPermi('pro:materialReturn:export')")
    @Log(title = "生产报工记录:统计方式工序导出", businessType = BusinessType.EXPORT)
    @PostMapping("/getListByProcess/export")
    @ApiOperation("生产报工记录:统计方式工序导出")
    public void getListByProcessExport(HttpServletResponse response, FeedbackRequest feedbackRequest) {
        List<FeedbackResponse> feedbackResponseList = feedbackService.getListByProcess(feedbackRequest);
        DecimalFormat df = new DecimalFormat("0.00%");
        for(FeedbackResponse feedbackResponse : feedbackResponseList){
            if(feedbackResponse.getQuantityFeedback() != null
                    && feedbackResponse.getQuantityFeedback().compareTo(BigDecimal.ZERO) != 0
                    && feedbackResponse.getQuantityUnqualify()!= null ){
                feedbackResponse.setQualificationRate(df.format((feedbackResponse.getQuantityQualify().divide(feedbackResponse.getQuantityQualify().add(feedbackResponse.getQuantityUnqualify()),2, RoundingMode.HALF_UP).doubleValue())));
            }else{
                feedbackResponse.setQualificationRate("0.00%");
            }
        }
        ExcelUtil<FeedbackResponse> util = new ExcelUtil<>(FeedbackResponse.class);
        util.exportExcel(response, feedbackResponseList, "生产报工报表-统计方式工序");
    }

    @ApiOperation("生产报工记录:统计方式用户")
    @PreAuthorize("@ss.hasPermi('mes:pro:feedback:get')")
    @Log(title = "生产报工记录:统计方式用户", businessType = BusinessType.QUERY)
    @GetMapping("/getListByUser")
    public TableDataInfo<FeedbackResponse> getListByUser(     FeedbackRequest feedbackRequest) {
        startPage();
        List<FeedbackResponse> feedbackResponseList = feedbackService.getListByUser(feedbackRequest);
        DecimalFormat df = new DecimalFormat("0.00%");
        for(FeedbackResponse feedbackResponse : feedbackResponseList){
            if(feedbackResponse.getQuantityFeedback() != null
                    && feedbackResponse.getQuantityFeedback().compareTo(BigDecimal.ZERO) != 0
                    && feedbackResponse.getQuantityUnqualify()!= null ){
                feedbackResponse.setQualificationRate(df.format((feedbackResponse.getQuantityQualify().divide(feedbackResponse.getQuantityQualify().add(feedbackResponse.getQuantityUnqualify()),2, RoundingMode.HALF_UP).doubleValue())));
            }else{
                feedbackResponse.setQualificationRate("0.00%");
            }
        }
        return getDataTable(feedbackResponseList);
    }

    /**
     * 统计方式车间界面导出
     */
    @PreAuthorize("@ss.hasPermi('pro:materialReturn:export')")
    @Log(title = "生产报工记录:统计方式用户导出", businessType = BusinessType.EXPORT)
    @PostMapping("/getListByUser/export")
    @ApiOperation("生产报工记录:统计方式用户导出")
    public void getListByUserExport(HttpServletResponse response, FeedbackRequest feedbackRequest) {
        List<FeedbackResponse> feedbackResponseList = feedbackService.getListByUser(feedbackRequest);
        DecimalFormat df = new DecimalFormat("0.00%");
        for(FeedbackResponse feedbackResponse : feedbackResponseList){
            if(feedbackResponse.getQuantityFeedback() != null
                    && feedbackResponse.getQuantityFeedback().compareTo(BigDecimal.ZERO) != 0
                    && feedbackResponse.getQuantityUnqualify()!= null ){
                feedbackResponse.setQualificationRate(df.format((feedbackResponse.getQuantityQualify().divide(feedbackResponse.getQuantityQualify().add(feedbackResponse.getQuantityUnqualify()),2, RoundingMode.HALF_UP).doubleValue())));
            }else{
                feedbackResponse.setQualificationRate("0.00%");
            }
        }
        ExcelUtil<FeedbackResponse> util = new ExcelUtil<>(FeedbackResponse.class);
        util.exportExcel(response, feedbackResponseList, "生产报工报表-统计方式用户");
    }




    @ApiOperation("生产报工记录:统计方式不合格原因")
    @PreAuthorize("@ss.hasPermi('mes:pro:feedback:get')")
    @Log(title = "生产报工记录:统计方式不合格原因", businessType = BusinessType.QUERY)
    @GetMapping("/getListByDefect")
    public TableDataInfo<FeedbackResponse> getListByDefect(     FeedbackRequest feedbackRequest) {
        startPage();
        List<FeedbackResponse> feedbackResponseList = feedbackService.getListByDefect(feedbackRequest);
        DecimalFormat df = new DecimalFormat("0.00%");
        for(FeedbackResponse feedbackResponse : feedbackResponseList){
            if(feedbackResponse.getQuantityFeedback() != null
                    && feedbackResponse.getQuantityFeedback().compareTo(BigDecimal.ZERO) != 0
                    && feedbackResponse.getQuantityUnqualify()!= null ){
                feedbackResponse.setQualificationRate(df.format((feedbackResponse.getQuantityQualify().divide(feedbackResponse.getQuantityQualify().add(feedbackResponse.getQuantityUnqualify()),2, RoundingMode.HALF_UP).doubleValue())));
            }else{
                feedbackResponse.setQualificationRate("0.00%");
            }
        }
        return getDataTable(feedbackResponseList);
    }




    /**
     * 统计方式车间界面导出
     */
    @PreAuthorize("@ss.hasPermi('pro:materialReturn:export')")
    @Log(title = "生产报工记录:统计方式不合格原因导出", businessType = BusinessType.EXPORT)
    @PostMapping("/getListByDefect/export")
    @ApiOperation("生产报工记录:统计方式不合格原因导出")
    public void getListByDefectExport(HttpServletResponse response, FeedbackRequest feedbackRequest) {
        List<FeedbackResponse> feedbackResponseList = feedbackService.getListByDefect(feedbackRequest);
        DecimalFormat df = new DecimalFormat("0.00%");
        for(FeedbackResponse feedbackResponse : feedbackResponseList){
            if(feedbackResponse.getQuantityFeedback() != null
                    && feedbackResponse.getQuantityFeedback().compareTo(BigDecimal.ZERO) != 0
                    && feedbackResponse.getQuantityUnqualify()!= null ){
                feedbackResponse.setQualificationRate(df.format((feedbackResponse.getQuantityQualify().divide(feedbackResponse.getQuantityQualify().add(feedbackResponse.getQuantityUnqualify()),2, RoundingMode.HALF_UP).doubleValue())));
            }else{
                feedbackResponse.setQualificationRate("0.00%");
            }
        }
        ExcelUtil<FeedbackResponse> util = new ExcelUtil<>(FeedbackResponse.class);
        util.exportExcel(response, feedbackResponseList, "生产报工报表-统计方式不合格原因");
    }
}
