package com.ximai.mes.pro.service.impl.prototypeMake;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import cn.hutool.core.bean.BeanUtil;
import com.ximai.mes.pro.domain.vo.ProPrototypeMakeProcessQcindexVo;
import com.ximai.mes.qc.domain.QcIndex;
import com.ximai.mes.qc.mapper.QcIndexMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ximai.mes.pro.mapper.prototypeMake.ProPrototypeMakeProcessQcindexMapper;
import com.ximai.mes.pro.domain.prototypeMake.ProPrototypeMakeProcessQcindex;
import com.ximai.mes.pro.service.prototypeMake.IProPrototypeMakeProcessQcindexService;

/**
 * 打样制作工序检验项Service业务层处理
 *
 * @author generator
 * @date 2024-01-27
 */
@Service
public class ProPrototypeMakeProcessQcindexServiceImpl implements IProPrototypeMakeProcessQcindexService
{
    @Autowired
    private ProPrototypeMakeProcessQcindexMapper proPrototypeMakeProcessQcindexMapper;
    @Autowired
    private QcIndexMapper qcIndexMapper;

    /**
     * 查询打样制作工序检验项
     *
     * @param prototypeMakeProcessQcindexId 打样制作工序检验项主键
     * @return 打样制作工序检验项
     */
    @Override
    public ProPrototypeMakeProcessQcindex selectProPrototypeMakeProcessQcindexByPrototypeMakeProcessQcindexId(Long prototypeMakeProcessQcindexId)
    {
        return proPrototypeMakeProcessQcindexMapper.selectProPrototypeMakeProcessQcindexByPrototypeMakeProcessQcindexId(prototypeMakeProcessQcindexId);
    }

    /**
     * 查询打样制作工序检验项列表
     *
     * @param proPrototypeMakeProcessQcindex 打样制作工序检验项
     * @return 打样制作工序检验项
     */
    @Override
    public List<ProPrototypeMakeProcessQcindex> selectProPrototypeMakeProcessQcindexList(ProPrototypeMakeProcessQcindex proPrototypeMakeProcessQcindex)
    {
        return proPrototypeMakeProcessQcindexMapper.selectProPrototypeMakeProcessQcindexList(proPrototypeMakeProcessQcindex);
    }

    @Override
    public List<ProPrototypeMakeProcessQcindexVo> selectProPrototypeMakeProcessQcindexVoList(ProPrototypeMakeProcessQcindex proPrototypeMakeProcessQcindex)
    {
        List<ProPrototypeMakeProcessQcindexVo> rst = new ArrayList<ProPrototypeMakeProcessQcindexVo>();
        ProPrototypeMakeProcessQcindex query = new ProPrototypeMakeProcessQcindex();
        query.setPrototypeMakeId(proPrototypeMakeProcessQcindex.getPrototypeMakeId());
        List<ProPrototypeMakeProcessQcindex> list = proPrototypeMakeProcessQcindexMapper.selectProPrototypeMakeProcessQcindexList(query);
        List<Long> ids = list.stream().map(s->s.getQcindexId()).collect(Collectors.toList());
        Map<Long, QcIndex> qcIndexMap = new HashMap<Long, QcIndex>();
        if(ids.size()>0){
            qcIndexMap.putAll(qcIndexMapper.selectBatchIds(ids).stream().collect(Collectors.toMap(s->s.getIndexId(), s->s)));
        }
        list.forEach(s->{
            ProPrototypeMakeProcessQcindexVo vo = new ProPrototypeMakeProcessQcindexVo();
            BeanUtil.copyProperties(s, vo);
            if(qcIndexMap.containsKey(s.getQcindexId())){
                BeanUtil.copyProperties(qcIndexMap.get(s.getQcindexId()), vo);
            }
            rst.add(vo);
        });
        return rst;
    }

    /**
     * 新增打样制作工序检验项
     *
     * @param proPrototypeMakeProcessQcindex 打样制作工序检验项
     * @return 结果
     */
    @Override
    public int insertProPrototypeMakeProcessQcindex(ProPrototypeMakeProcessQcindex proPrototypeMakeProcessQcindex)
    {
        return proPrototypeMakeProcessQcindexMapper.insertProPrototypeMakeProcessQcindex(proPrototypeMakeProcessQcindex);
    }

    /**
     * 修改打样制作工序检验项
     *
     * @param proPrototypeMakeProcessQcindex 打样制作工序检验项
     * @return 结果
     */
    @Override
    public int updateProPrototypeMakeProcessQcindex(ProPrototypeMakeProcessQcindex proPrototypeMakeProcessQcindex)
    {
        return proPrototypeMakeProcessQcindexMapper.updateProPrototypeMakeProcessQcindex(proPrototypeMakeProcessQcindex);
    }

    /**
     * 批量删除打样制作工序检验项
     *
     * @param prototypeMakeProcessQcindexIds 需要删除的打样制作工序检验项主键
     * @return 结果
     */
    @Override
    public int deleteProPrototypeMakeProcessQcindexByPrototypeMakeProcessQcindexIds(Long[] prototypeMakeProcessQcindexIds)
    {
        return proPrototypeMakeProcessQcindexMapper.deleteProPrototypeMakeProcessQcindexByPrototypeMakeProcessQcindexIds(prototypeMakeProcessQcindexIds);
    }

    /**
     * 删除打样制作工序检验项信息
     *
     * @param prototypeMakeProcessQcindexId 打样制作工序检验项主键
     * @return 结果
     */
    @Override
    public int deleteProPrototypeMakeProcessQcindexByPrototypeMakeProcessQcindexId(Long prototypeMakeProcessQcindexId)
    {
        return proPrototypeMakeProcessQcindexMapper.deleteProPrototypeMakeProcessQcindexByPrototypeMakeProcessQcindexId(prototypeMakeProcessQcindexId);
    }
}
