package com.ximai.mes.pro.schedule;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.math.BigDecimal;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;

/**
 * 作业时间计算
 */
public interface IOperationTimeCalculator {

    /**
     * 计算作业时间
     */
    OperationTimePlan calculate(TaskSchedulingContext context);

    /**
     * 设备排产明细
     */
    @Data
    public class OperationTimePlan
    {

        /**
         * 产能是否满足
         */
        private Boolean scheduledSuccess;

        private Equipment equipment;

        private List<OperationTimePlanItem> plan=new ArrayList<OperationTimePlanItem>();

        private double score = 0;

        /**
         * 总工时
         */
        private Duration totalTime;

    }

    /**
     * 设备排产时间段
     */
    @Data
    @AllArgsConstructor
    @NoArgsConstructor
    public class OperationTimePlanItem
    {
        private BigDecimal quantity;
        private Duration startedTime;
        private Duration endedTime;
        private String shiftType;
    }
}
