package com.ximai.mes.pro.mapper;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.ximai.mes.pro.domain.ProMaterialRequest;
import com.ximai.mes.pro.domain.vo.ProMaterialRequestVo;
import org.apache.ibatis.annotations.Delete;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;

import java.util.List;

/**
 * 领料申请Mapper接口
 *
 * @author generator
 * @date 2024-02-22
 */
public interface ProMaterialRequestMapper extends BaseMapper<ProMaterialRequest> {
    /**
     * 查询领料申请
     *
     * @param materialRequestId 领料申请主键
     * @return 领料申请
     */
    ProMaterialRequest selectProMaterialRequestByMaterialRequestId(Long materialRequestId);

    /**
     * 查询领料申请列表
     *
     * @param proMaterialRequest 领料申请
     * @return 领料申请集合
     */
    List<ProMaterialRequest> selectProMaterialRequestList(ProMaterialRequest proMaterialRequest);


    @Select(value = "select p.*,m.item_code, m.sap_item_code, m.item_name, pr.arrange_code ,pr.task_code from pro_material_request p  left join md_item m on p.item_id=m.item_id " +
            "left join pro_task pr on p.task_id=pr.task_id\n" +
            " ${ew.customSqlSegment} ")
    List<ProMaterialRequestVo> selectListByQw(@Param("ew") QueryWrapper<ProMaterialRequest> query);

    @Select(value = "select * from pro_material_request " +
            " ${ew.customSqlSegment} ")
    List<ProMaterialRequest> selectListByQw2(@Param("ew") QueryWrapper<ProMaterialRequest> query);


    @Select(value = "select p.material_request_id, p.grant_num, p.wind_case, p.workstation_code, p.workstation_name, p.apply_no, p.item_id, p.material_type, p.workorder_code, p.task_id, p.apply_num, p.remark, p.attr1, p.attr2, p.attr3, p.attr4, p.create_by, p.create_time, p.update_by, p.update_time,p.start_time,p.end_time,p.workunit_name, p.workunit_code, p.apply_type,m.item_code, m.sap_item_code, m.item_name, pr.arrange_code ,pr.task_code from pro_material_request p  left join md_item m on p.item_id=m.item_id " +
            "left join pro_task pr on p.task_id=pr.task_id\n" +
            " ${ew.customSqlSegment} ")
    List<ProMaterialRequestVo> selectProMaterialRequestLis(@Param("ew") QueryWrapper<ProMaterialRequest> query);

    @Select(value = "select p.material_request_id, p.grant_num, p.wind_case, p.requirement_number, p.requirement_project_number, p.workstation_code, p.workstation_name, p.apply_no, p.item_id, p.material_type, p.workorder_code, p.task_id, p.apply_num, p.remark, p.attr1, p.attr2, p.attr3, p.attr4, p.create_by, p.create_time, p.update_by, p.update_time,p.start_time,p.end_time,p.workunit_name, p.workunit_code, p.apply_type,m.item_code, m.sap_item_code, m.item_name, pr.arrange_code ,pr.task_code from pro_material_request p  left join md_item m on p.item_id=m.item_id " +
            "left join pro_task pr on p.task_id=pr.task_id\n" +
            " ${ew.customSqlSegment} order by  p.grant_num IS NULL desc, p.create_time desc")
    List<ProMaterialRequestVo> selectProMaterialRequestLisA(@Param("ew") QueryWrapper<ProMaterialRequest> query);


    /**
     * 新增领料申请
     *
     * @param proMaterialRequest 领料申请
     * @return 结果
     */
    int insertProMaterialRequest(ProMaterialRequest proMaterialRequest);

    /**
     * 修改领料申请
     *
     * @param proMaterialRequest 领料申请
     * @return 结果
     */
    int updateProMaterialRequest(ProMaterialRequest proMaterialRequest);

    /**
     * 删除领料申请
     *
     * @param materialRequestId 领料申请主键
     * @return 结果
     */
    int deleteProMaterialRequestByMaterialRequestId(Long materialRequestId);

    /**
     * 批量删除领料申请
     *
     * @param materialRequestIds 需要删除的数据主键集合
     * @return 结果
     */
    int deleteProMaterialRequestByMaterialRequestIds(Long[] materialRequestIds);

    @Delete("delete from pro_material_request where task_workunit_id = #{taskWorkunitId}")
    void deleteByTaskWorkunitId(Long taskWorkunitId);


    @Delete("delete from pro_material_request ${ew.customSqlSegment}")
    void deleteProMaterialRequest(@Param("ew") QueryWrapper<ProMaterialRequest> query);


    List<ProMaterialRequestVo> selectMaterialRequestPrintTab(@Param(value = "ids")List<String> ids);

    List<ProMaterialRequestVo> selectMaterialRequestPrintTabByApplyNo(@Param(value = "applyNo") String applyNo);
}
