package com.ximai.mes.dv.service.impl.dvBrandQuotation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import cn.hutool.core.bean.BeanUtil;
import com.ximai.mes.dv.domain.devBrandQuotation.DevBrandQuotationProcessTool;
import com.ximai.mes.dv.domain.vo.DevBrandQuotationProcessToolVo;
import com.ximai.mes.dv.mapper.devBrandQuotation.DevBrandQuotationProcessToolMapper;
import com.ximai.mes.dv.service.devBrandQuotation.IDevBrandQuotationProcessToolService;
import com.ximai.mes.md.domain.MdItem;
import com.ximai.mes.md.mapper.MdItemMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * 品牌报价工序工装夹具Service业务层处理
 *
 * @author generator
 * @date 2024-01-28
 */
@Service
public class DevBrandQuotationProcessToolServiceImpl implements IDevBrandQuotationProcessToolService
{
    @Autowired
    private DevBrandQuotationProcessToolMapper devBrandQuotationProcessToolMapper;

    @Autowired
    private MdItemMapper mdItemMapper;

    /**
     * 查询品牌报价工序工装夹具
     *
     * @param brandQuotationProcessToolId 品牌报价工序工装夹具主键
     * @return 品牌报价工序工装夹具
     */
    @Override
    public DevBrandQuotationProcessTool selectDevBrandQuotationProcessToolByBrandQuotationProcessToolId(Long brandQuotationProcessToolId)
    {
        return devBrandQuotationProcessToolMapper.selectDevBrandQuotationProcessToolByBrandQuotationProcessToolId(brandQuotationProcessToolId);
    }

    /**
     * 查询品牌报价工序工装夹具列表
     *
     * @param devBrandQuotationProcessTool 品牌报价工序工装夹具
     * @return 品牌报价工序工装夹具
     */
    @Override
    public List<DevBrandQuotationProcessTool> selectDevBrandQuotationProcessToolList(DevBrandQuotationProcessTool devBrandQuotationProcessTool)
    {
        return devBrandQuotationProcessToolMapper.selectDevBrandQuotationProcessToolList(devBrandQuotationProcessTool);
    }

    /**
     * 新增品牌报价工序工装夹具
     *
     * @param devBrandQuotationProcessTool 品牌报价工序工装夹具
     * @return 结果
     */
    @Override
    public int insertDevBrandQuotationProcessTool(DevBrandQuotationProcessTool devBrandQuotationProcessTool)
    {
        return devBrandQuotationProcessToolMapper.insertDevBrandQuotationProcessTool(devBrandQuotationProcessTool);
    }

    /**
     * 修改品牌报价工序工装夹具
     *
     * @param devBrandQuotationProcessTool 品牌报价工序工装夹具
     * @return 结果
     */
    @Override
    public int updateDevBrandQuotationProcessTool(DevBrandQuotationProcessTool devBrandQuotationProcessTool)
    {
        return devBrandQuotationProcessToolMapper.updateDevBrandQuotationProcessTool(devBrandQuotationProcessTool);
    }

    /**
     * 批量删除品牌报价工序工装夹具
     *
     * @param brandQuotationProcessToolIds 需要删除的品牌报价工序工装夹具主键
     * @return 结果
     */
    @Override
    public int deleteDevBrandQuotationProcessToolByBrandQuotationProcessToolIds(Long[] brandQuotationProcessToolIds)
    {
        return devBrandQuotationProcessToolMapper.deleteDevBrandQuotationProcessToolByBrandQuotationProcessToolIds(brandQuotationProcessToolIds);
    }

    /**
     * 删除品牌报价工序工装夹具信息
     *
     * @param brandQuotationProcessToolId 品牌报价工序工装夹具主键
     * @return 结果
     */
    @Override
    public int deleteDevBrandQuotationProcessToolByBrandQuotationProcessToolId(Long brandQuotationProcessToolId)
    {
        return devBrandQuotationProcessToolMapper.deleteDevBrandQuotationProcessToolByBrandQuotationProcessToolId(brandQuotationProcessToolId);
    }

    @Override
    public List<DevBrandQuotationProcessToolVo> selectDevBrandQuotationProcessToolVoList(DevBrandQuotationProcessTool devBrandQuotationProcessTool)
    {
        List<DevBrandQuotationProcessToolVo> rst = new ArrayList<DevBrandQuotationProcessToolVo>();
        DevBrandQuotationProcessTool query = new DevBrandQuotationProcessTool();
        query.setBrandQuotationId(devBrandQuotationProcessTool.getBrandQuotationId());
        List<DevBrandQuotationProcessTool> list = devBrandQuotationProcessToolMapper.selectDevBrandQuotationProcessToolList(query);
        List<Long> ids = list.stream().map(s->s.getToolId()).collect(Collectors.toList());
        Map<Long, MdItem> toolMap = new HashMap<Long, MdItem>();
        if(ids.size()>0){
            toolMap.putAll(mdItemMapper.selectBatchIds(ids).stream().collect(Collectors.toMap(s->s.getItemId(), s->s)));
        }
        list.forEach(s->{
            DevBrandQuotationProcessToolVo vo = new DevBrandQuotationProcessToolVo();
            BeanUtil.copyProperties(s, vo);
            if(toolMap.containsKey(s.getToolId())){
                BeanUtil.copyProperties(toolMap.get(s.getToolId()), vo);
            }
            rst.add(vo);
        });
        return rst;
    }
}
