package com.ximai.system.domain;

import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson.JSON;
import com.ximai.common.annotation.Excel;
import com.ximai.common.annotation.Excel.ColumnType;
import com.ximai.common.core.domain.BaseEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.ximai.common.exception.ServiceException;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.apache.commons.lang3.StringUtils;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 操作日志记录表 oper_log
 */
@Data
public class SysApiLog extends BaseEntity {
    private static final long serialVersionUID = 1L;

    /**
     * 日志主键
     */
    @Excel(name = "操作序号", cellType = ColumnType.NUMERIC)
    private Long operId;

    /**
     * 操作模块
     */
    @Excel(name = "操作模块")
    private String title;

    /**
     * 业务类型（0其它 1新增 2修改 3删除）
     */
    @Excel(name = "业务类型", readConverterExp = "0=其它,1=新增,2=修改,3=删除,4=授权,5=导出,6=导入,7=强退,8=生成代码,9=清空数据")
    private Integer businessType;

    /**
     * 业务类型数组
     */
    private Integer[] businessTypes;

    /**
     * 请求方法
     */
    @Excel(name = "请求方法")
    private String method;

    /**
     * 请求方式
     */
    @Excel(name = "请求方式")
    private String requestMethod;

    /**
     * 操作类别（0其它 1后台用户 2手机端用户）
     */
    @Excel(name = "操作类别", readConverterExp = "0=其它,1=后台用户,2=手机端用户")
    private Integer operatorType;

    /**
     * 操作人员
     */
    @Excel(name = "操作人员")
    private String operName;

    /**
     * 部门名称
     */
    @Excel(name = "部门名称")
    private String deptName;

    /**
     * 请求url
     */
    @Excel(name = "请求地址")
    private String operUrl;

    /**
     * 操作地址
     */
    @Excel(name = "操作地址")
    private String operIp;

    /**
     * 操作地点
     */
    @Excel(name = "操作地点")
    private String operLocation;

    @ApiModelProperty(value = "方法参数1")
    private String operParam1;
    @ApiModelProperty(value = "方法参数2")
    private String operParam2;
    @ApiModelProperty(value = "方法参数3")
    private String operParam3;
    @ApiModelProperty(value = "方法参数4")
    private String operParam4;
    @ApiModelProperty(value = "方法参数5")
    private String operParam5;

    /**
     * 请求参数
     */
    @ApiModelProperty(value = "参数类型")
    private String paramType;

    /**
     * 返回参数
     */
    @Excel(name = "返回参数")
    private String jsonResult;

    /**
     * 操作状态（0正常 1异常）
     */
    @Excel(name = "状态", readConverterExp = "0=正常,1=异常")
    private Integer status;

    /**
     * 错误消息
     */
    @Excel(name = "错误消息")
    private String errorMsg;

    /**
     * 操作时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @Excel(name = "操作时间", width = 30, dateFormat = "yyyy-MM-dd HH:mm:ss")
    private Date operTime;

    public Object[] parseParamObject() throws ClassNotFoundException {
        List<String> params = new ArrayList<String>();
        if(StringUtils.isNotEmpty(this.getOperParam1())){
            params.add(this.getOperParam1());
        }
        if(StringUtils.isNotEmpty(this.getOperParam2())){
            params.add(this.getOperParam2());
        }
        if(StringUtils.isNotEmpty(this.getOperParam3())){
            params.add(this.getOperParam3());
        }
        if(StringUtils.isNotEmpty(this.getOperParam4())){
            params.add(this.getOperParam4());
        }
        if(StringUtils.isNotEmpty(this.getOperParam5())){
            params.add(this.getOperParam5());
        }
        String[] paramTypeArr = this.getParamType().split(",");
        List<Object> paramsObj = new ArrayList<>();
        int i=0;
        if(paramTypeArr.length!=params.size()){
            throw new ServiceException("参数不致，检查方法是否发生变化");
        }
        for (String param : params) {
            Class clz = Class.forName(paramTypeArr[i]);
            Object obj1 = JSONUtil.toBean(param, clz);
            paramsObj.add(obj1);
            i++;
        }
        return paramsObj.toArray();
    }
}
