package com.ximai.mes.wm.service;

import com.ximai.mes.wm.domain.WmIssueHeader;
import com.ximai.mes.wm.domain.tx.IssueTxBean;
import com.ximai.mes.wm.domain.vo.WmIssueVo;

import java.util.List;

/**
 * 生产领料单头Service接口
 *
 * @date 2022-07-14
 */
public interface IWmIssueHeaderService {

    /**
     * 查询生产领料单头
     *
     * @param issueId 生产领料单头主键
     * @return 生产领料单头
     */
    WmIssueHeader selectWmIssueHeaderByIssueId(Long issueId);

    /**
     * 查询生产领料单头列表
     *
     * @param wmIssueHeader 生产领料单头
     * @return 生产领料单头集合
     */
    List<WmIssueHeader> selectWmIssueHeaderList(WmIssueHeader wmIssueHeader);

    /**
     * 检查生产领料单编号是否唯一
     *
     * @param wmIssueHeader
     * @return
     */
    String checkIssueCodeUnique(WmIssueHeader wmIssueHeader);

    /**
     * 新增生产领料单头
     *
     * @param wmIssueHeader 生产领料单头
     * @return 结果
     */
    int insertWmIssueHeader(WmIssueHeader wmIssueHeader);

    /**
     * 修改生产领料单头
     *
     * @param wmIssueHeader 生产领料单头
     * @return 结果
     */
    int updateWmIssueHeader(WmIssueHeader wmIssueHeader);

    /**
     * 批量删除生产领料单头
     *
     * @param issueIds 需要删除的生产领料单头主键集合
     * @return 结果
     */
    int deleteWmIssueHeaderByIssueIds(Long[] issueIds);

    /**
     * 删除生产领料单头信息
     *
     * @param issueId 生产领料单头主键
     * @return 结果
     */
    int deleteWmIssueHeaderByIssueId(Long issueId);

    List<IssueTxBean> getTxBeans(Long issueId);

    @Deprecated
    void insertWmIssueHeaderByTaskId(Long taskId);


    void sapCreateObj(List<WmIssueVo> wmIssueVos);

    void insertPadWmIssueHeader(List<WmIssueVo> wmIssueVos);
}
