package com.ximai.mes.qt.domain;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.ximai.common.annotation.Excel;
import com.ximai.common.core.domain.BaseEntity;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

import java.math.BigDecimal;
import java.util.Date;

/**
 * 工厂报价对象 qt_factory_quote
 *
 * @author yinjinlu
 * @date 2024-01-24
 */
@Getter
@Setter
@ToString
public class QtFactoryQuote extends BaseEntity {
    private static final long serialVersionUID = 1L;

    private Long id;

    /**
     * 客户ID
     */
    @Excel(name = "客户ID")
    private Long clientId;

    private String clientCode;

    private String clientName;

    /**
     * 产品ID
     */
    @Excel(name = "产品ID")
    private Long itemId;

    private String itemCode;

    private String itemName;

    /**
     * 价格
     */
    @Excel(name = "价格")
    private BigDecimal price;

    /**
     * 有效期起
     */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "有效期起", width = 30, dateFormat = "yyyy-MM-dd")
    private Date validFrom;

    /**
     * 有效期至
     */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "有效期至", width = 30, dateFormat = "yyyy-MM-dd")
    private Date validTo;

    /**
     * 状态: 0草稿, 1审批中, 2发布中, 3确认
     */
    @Excel(name = "状态: 0草稿, 1审批中, 2发布中, 3确认")
    private String state;

}
