package com.ximai.mes.qc.service;

import com.ximai.mes.qc.domain.QcIqc;

import java.util.List;

/**
 * 来料检验单Service接口
 *
 * @date 2022-05-19
 */
public interface IQcIqcService {
    /**
     * 查询来料检验单
     *
     * @param iqcId 来料检验单主键
     * @return 来料检验单
     */
    QcIqc selectQcIqcByIqcId(Long iqcId);

    /**
     * 查询来料检验单列表
     *
     * @param qcIqc 来料检验单
     * @return 来料检验单集合
     */
    List<QcIqc> selectQcIqcList(QcIqc qcIqc);

    /**
     * 检查来料检验单号是否重复
     *
     * @param qcIqc
     * @return
     */
    String checkIqcCodeUnique(QcIqc qcIqc);

    /**
     * 新增来料检验单
     *
     * @param qcIqc 来料检验单
     * @return 结果
     */
    int insertQcIqc(QcIqc qcIqc);

    int insertObj(QcIqc qcIqc);

    /**
     * 修改来料检验单
     *
     * @param qcIqc 来料检验单
     * @return 结果
     */
    int updateQcIqc(QcIqc qcIqc);

    int updateCrMajMinQuaAndRate(Long iqcId);

    /**
     * 批量删除来料检验单
     *
     * @param iqcIds 需要删除的来料检验单主键集合
     * @return 结果
     */
    int deleteQcIqcByIqcIds(Long[] iqcIds);

    /**
     * 删除来料检验单信息
     *
     * @param iqcId 来料检验单主键
     * @return 结果
     */
    int deleteQcIqcByIqcId(Long iqcId);

    int deleteQcIqcByIqcCode(String iqcCode);

    int updateObj(QcIqc qcIqc);
}
