package com.ximai.mes.pro.dto;

import io.swagger.annotations.ApiModelProperty;
import com.baomidou.mybatisplus.annotation.TableId;
import lombok.Data;
import java.util.Date;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 入库明细记录对象 pro_storage_detail_record
 *
 * @author generator
 * @date 2025-10-12
 */
@Data
public class ProStorageDetailRecordDto {
    private static final long serialVersionUID = 1L;

    /** 记录ID */
    @TableId
    @ApiModelProperty("记录ID")
    private Long recordId;

    /** 工单单别 */
    @ApiModelProperty("工单单别")
    private String workOrderType;

    /** 工单单号 */
    @ApiModelProperty("工单单号")
    private String workOrderNo;

    /** 箱码 */
    @ApiModelProperty("箱码")
    private String boxCode;

    /** 小标签号 */
    @ApiModelProperty("小标签号")
    private String labelNo;

    /** 创建者 */
    @ApiModelProperty("创建者")
    private String createBy;

    /** 创建时间 */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty("创建时间")
    private Date createTime;

    /** 更新者 */
    @ApiModelProperty("更新者")
    private String updateBy;

    /** 更新时间 */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty("更新时间")
    private Date updateTime;
}

