package com.ximai.mes.pro.domain.vo.proWorkOrder;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.math.BigDecimal;
import java.util.Date;

/**
 * 装箱条码打印参数
 *
 * @author lcc
 * @date 2024-02-29
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class WorkOrderPackageParams {

    @ApiModelProperty("工单ID")
    private Long workorderId;

    @ApiModelProperty("净重")
    private BigDecimal netWeight;

    @ApiModelProperty("包装数量")
    private BigDecimal packNum;

    @ApiModelProperty("装箱数量")
    private Integer encasementNum;

    @Deprecated
    @ApiModelProperty("小包数量")
    private Integer minPackageNum;

    @ApiModelProperty("录入人员")
    private String inputBy;

    @ApiModelProperty("检验人员")
    private String checkBy;

    @ApiModelProperty("录入时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm")
    private Date inputTime;

}
