package com.ximai.mes.pro.domain.productionSolution;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.ximai.common.annotation.Excel;
import com.ximai.common.core.domain.BaseEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.math.BigDecimal;
import java.util.Date;

/**
 * 生产版本对象 pro_production_solution
 *
 * @author zht
 * @date 2024-01-23
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class ProProductionSolution extends BaseEntity {
    private static final long serialVersionUID = 1L;

    /**
     * ID
     */
    @TableId(type = IdType.AUTO)
    private Long productionSolutionId;

    /**
     * 编码
     */
    @ApiModelProperty("编码")
    private String productionSolutionCode;

    /**
     * 名称
     */
    @Excel(name = "名称")
    @ApiModelProperty("名称")
    private String productionSolutionName;
    /**
     * 名称
     */
    @Excel(name = "类型")
    @ApiModelProperty("类型")
    private String productionSolutionType;

    /**
     * SAP打样工单号
     */
    @ApiModelProperty("SAP打样工单号")
    private String sapPrototypeMakeCode;

    /**
     * 产品ID
     */
    @Excel(name = "产品ID")
    @ApiModelProperty("产品ID")
    private Long itemId;

    @TableField(exist = false)
    private String itemName;

    @Excel(name = "产品编码")
    private String itemCode;

    /**
     * 工艺路线ID
     */
    @Excel(name = "工艺路线ID")
    @ApiModelProperty("工艺路线ID")
    private Long routeId;

    /**
     * 工艺路线名称
     */
    @TableField(exist = false)
    private String routeName;
    /**
     * 生产用途
     */
    @Excel(name = "生产用途")
    @ApiModelProperty("生产用途")
    private Long usageId;

    /**
     * 生产用途名称
     */
    @TableField(exist = false)
    private String usageName;
    /**
     * SAP物料编码
     */
    @Excel(name = "SAP物料编码")
    @ApiModelProperty("SAP物料编码")
    private String sapItemCode;

    /**
     * 工厂编码
     */
    @Excel(name = "工厂编码")
    @ApiModelProperty("工厂编码")
    private String factoryCode;

    /**
     * 任务清单组键值
     */
    @Excel(name = "任务清单组键值")
    @ApiModelProperty("任务清单组键值")
    private String groupKey;

    /**
     * 组计数器
     */
    @Excel(name = "组计数器")
    @ApiModelProperty("组计数器")
    private String groupCounter;

    /**
     * 物料清单组号
     */
    @Excel(name = "物料清单组号")
    @ApiModelProperty("物料清单组号")
    private String materialsGroupBill;

    /**
     * 备选物料清单
     */
    @Excel(name = "备选物料清单")
    @ApiModelProperty("备选物料清单")
    private String alternativeBill;

    /**
     * 状态
     */
    @Excel(name = "状态")
    private String status;

    /**
     * 有效起始日期
     */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "有效起始日期", width = 30, dateFormat = "yyyy-MM-dd")
    private Date startDate;

    /**
     * 有效期截止日期
     */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "有效期截止日期", width = 30, dateFormat = "yyyy-MM-dd")
    private Date expiryDate;

    /**
     * 最小批量
     */
    @Excel(name = "最小批量")
    private BigDecimal maxLot;

    /**
     * 最大批量
     */
    @Excel(name = "最大批量")
    private BigDecimal minLot;

    /**
     * 备注
     */
    @Excel(name = "备注")
    private String remark;

    /**
     * 工程变更
     */
    @Excel(name = "工程变更")
    private String ecnCode;

    /**
     * 单位
     */
    @Excel(name = "单位")
    private String unitOfMeasure;

    /**
     * SAP用途
     */
    private String sapUsageId;

    /**
     * 单价
     */
    @ApiModelProperty("单价")
    private BigDecimal unitPrice;


    /**
     * 单价
     */
    @ApiModelProperty("超报")
    private Boolean surpassState;

    @ApiModelProperty("主档文件上传URL")
    private String url;
    @ApiModelProperty("主档文件上传地址")
    private String filePath;
    @ApiModelProperty("主档文件名称")
    private String originalFilename;
    @ApiModelProperty("产品图号")
    private String customerDrawingNo;
}
