package com.ximai.mes.pro.controller.proWorkOrder;

import com.ximai.common.annotation.Log;
import com.ximai.common.core.controller.BaseController;
import com.ximai.common.core.domain.AjaxResult;
import com.ximai.common.core.page.TableDataInfo;
import com.ximai.common.enums.BusinessType;
import com.ximai.mes.pro.domain.proWorkOrder.ProWorkOrderChangeRecord;
import com.ximai.mes.pro.service.proWorkOrder.IProWorkOrderChangeRecordService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * 工单变更记录Controller
 *
 * @author generator
 * @date 2024-04-18
 */
@RestController
@RequestMapping("/md/record")
public class ProWorkOrderChangeRecordController extends BaseController {
    @Autowired
    private IProWorkOrderChangeRecordService proWorkOrderChangeRecordService;

    /**
     * 查询工单变更记录列表
     */
    @PreAuthorize("@ss.hasPermi('md:record:list')")
    @GetMapping("/list")
    public TableDataInfo list(ProWorkOrderChangeRecord proWorkOrderChangeRecord) {
        startPage();
        List<ProWorkOrderChangeRecord> list = proWorkOrderChangeRecordService.selectProWorkOrderChangeRecordList(proWorkOrderChangeRecord);
        return getDataTable(list);
    }

    /**
     * 获取工单变更记录详细信息
     */
    @PreAuthorize("@ss.hasPermi('md:record:query')")
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id) {
        return AjaxResult.success(proWorkOrderChangeRecordService.selectProWorkOrderChangeRecordById(id));
    }

    /**
     * 新增工单变更记录
     */
    @PreAuthorize("@ss.hasPermi('md:record:add')")
    @Log(title = "工单变更记录", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody ProWorkOrderChangeRecord proWorkOrderChangeRecord) {
        return toAjax(proWorkOrderChangeRecordService.insertProWorkOrderChangeRecord(proWorkOrderChangeRecord));
    }

    /**
     * 修改工单变更记录
     */
    @PreAuthorize("@ss.hasPermi('md:record:edit')")
    @Log(title = "工单变更记录", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody ProWorkOrderChangeRecord proWorkOrderChangeRecord) {
        return toAjax(proWorkOrderChangeRecordService.updateProWorkOrderChangeRecord(proWorkOrderChangeRecord));
    }

    /**
     * 删除工单变更记录
     */
    @PreAuthorize("@ss.hasPermi('md:record:remove')")
    @Log(title = "工单变更记录", businessType = BusinessType.DELETE)
    @DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids) {
        return toAjax(proWorkOrderChangeRecordService.deleteProWorkOrderChangeRecordByIds(ids));
    }
}
