package com.ximai.mes.md.vo;


import com.ximai.common.annotation.Excel;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.math.BigDecimal;

@Data
@AllArgsConstructor
@NoArgsConstructor
public class MdWorkshopVo implements Serializable {
    /** 车间ID */
    private Long workshopId;

    /** 车间编码 */
    @Excel(name = "车间编码")
    private String workshopCode;

    /** 车间名称 */
    @Excel(name = "车间名称")
    private String workshopName;

    /** 面积 */
    @Excel(name = "面积")
    private BigDecimal area;

    /** 负责人 */
    @Excel(name = "负责人")
    private String charge;

    /** 是否启用 */
    @Excel(name = "是否启用")
    private String enableFlag;


    /** 备注 */
    @Excel(name = "备注")
    private String remark;


    /** 工厂ID */
    private Long factoryId;

    /** 工厂编码 */
    private String factoryCode;

    /** 预留字段1 */
    private String attr1;

    /** 预留字段2 */
    private String attr2;

    /** 预留字段3 */
    private Long attr3;

    /** 预留字段4 */
    private Long attr4;

    /**
     * 更新标志
     */
    private char updateLog;
}
