package com.ximai.mes.md.vo;

import com.ximai.common.annotation.Excel;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.ximai.common.core.domain.BaseEntity;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.ToString;

import java.util.Date;

/**
 * 产品基本信息对象 md_base_info
 *
 * @author yinjinlu
 * @date 2024-01-16
 */
@ToString
@Data
public class MdBaseInfoVo extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 产品id */
    private Long itemId;

    /** 产品代号 */
    private String productNo;

    /** 英文名称 */
    private String productEnglishName;


    /** 计量单位 */
    private String unitOfMeasure;

    /** 有效开始日期 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    private Date expirationDateStart;

    /** 有效结束日期 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    private Date expirationDateEnd;

    /** 品牌id */
    private Long brandId;

    /** 品牌名称 */
    private String brandName;

    /** 尺码组id */
    private Long sizeGroupId;

    /** 尺码组名称 */
    private String sizeGroupName;

    /** 版面(product_layout) */
    private String layout;

    /** 物料类型 */
    @Excel(name = "物料类型")
    private String materialType;

    /** 产品组 */
    @Excel(name = "产品组")
    private String productGroup;

    /** 毛重 */
    @Excel(name = "毛重")
    private String grossWeight;

    /** 净重 */
    @Excel(name = "净重")
    private String netWeight;

    /** 重量单位 */
    @Excel(name = "重量单位")
    private String weightUnit;

    /** 体积 */
    @Excel(name = "体积")
    private String volume;


    /** 体积 */
    @Excel(name = "体积")
    private String volumeUnit;

    @ApiModelProperty("包装数量")
    private Integer packageNum;

    @ApiModelProperty("装箱数量")
    private Integer encasementNum;

    /**
     * 是否排版
     */
    private String isLayout;

}
